/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.config;

import com.github.jcustenborder.kafka.connect.utils.config.ValidHostnameAndPort;
import com.github.jcustenborder.repackaged.com.google.common.base.Joiner;
import com.github.jcustenborder.repackaged.com.google.common.base.Preconditions;
import com.github.jcustenborder.repackaged.com.google.common.collect.ImmutableList;
import com.github.jcustenborder.repackaged.com.google.common.primitives.Ints;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.kafka.common.config.AbstractConfig;

public class ConfigUtils {
    public static <T> Class<T> getClass(AbstractConfig config, String key, Class<T> expected) {
        Preconditions.checkNotNull(config, "config cannot be null");
        Preconditions.checkNotNull(key, "key cannot be null");
        Preconditions.checkNotNull(expected, "expected cannot be null");
        Class cls = config.getClass(key);
        Preconditions.checkState(expected.isAssignableFrom(cls), "'%s' is not assignable from '%s'", (Object)expected.getSimpleName(), (Object)cls.getSimpleName());
        return cls;
    }

    public static <T extends Enum<T>> T getEnum(Class<T> enumClass, AbstractConfig config, String key) {
        Preconditions.checkNotNull(enumClass, "enumClass cannot be null");
        Preconditions.checkState(enumClass.isEnum(), "enumClass must be an enum.");
        String textValue = config.getString(key);
        return Enum.valueOf(enumClass, textValue);
    }

    public static String enumValues(Class<?> enumClass) {
        Preconditions.checkNotNull(enumClass, "enumClass cannot be null");
        Preconditions.checkState(enumClass.isEnum(), "enumClass must be an enum.");
        return Joiner.on(", ").join(enumClass.getEnumConstants());
    }

    public static File getAbsoluteFile(AbstractConfig config, String key) {
        Preconditions.checkNotNull(config, "config cannot be null");
        String path = config.getString(key);
        File file = new File(path);
        Preconditions.checkState(file.isAbsolute(), "'%s' must be an absolute path.", (Object)key);
        return new File(path);
    }

    static InetSocketAddress parseInetSocketAddress(String s) {
        Preconditions.checkNotNull(s, "s cannot be null.");
        Matcher matcher = ValidHostnameAndPort.HOSTNAME_PATTERN.matcher(s);
        Preconditions.checkState(matcher.matches(), "'%s' does not match '%s'", (Object)s, (Object)ValidHostnameAndPort.HOSTNAME_PATTERN.pattern());
        Integer port = Ints.tryParse(matcher.group(2));
        Preconditions.checkState(port >= 1 && port <= 65535, "Invalid port value %s. Must be between 1 and 65535", (Object)port);
        return new InetSocketAddress(matcher.group(1), (int)port);
    }

    public static InetSocketAddress inetSocketAddress(AbstractConfig config, String key) {
        Preconditions.checkNotNull(config, "config cannot be null");
        String value = config.getString(key);
        return ConfigUtils.parseInetSocketAddress(value);
    }

    public static List<InetSocketAddress> inetSocketAddresses(AbstractConfig config, String key) {
        Preconditions.checkNotNull(config, "config cannot be null");
        List value = config.getList(key);
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>(value.size());
        for (String s : value) {
            addresses.add(ConfigUtils.parseInetSocketAddress(s));
        }
        return ImmutableList.copyOf(addresses);
    }
}

