/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.config;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidHostnameAndPort
implements ConfigDef.Validator {
    private static final Logger log = LoggerFactory.getLogger(ValidHostnameAndPort.class);
    static final Pattern HOSTNAME_PATTERN = Pattern.compile("^(.+)\\:(\\d{1,5})$");

    public void ensureValid(String key, Object value) {
        log.trace("ensureValid('{}', '{}')", (Object)key, value);
        if (value instanceof String) {
            try {
                Matcher matcher = HOSTNAME_PATTERN.matcher((CharSequence)value);
                Preconditions.checkState((boolean)matcher.matches(), (String)"'%s' does not match pattern '%s'.", (Object)key, (Object)HOSTNAME_PATTERN.pattern());
                int port = Integer.parseInt(matcher.group(2));
                Preconditions.checkState((port >= 1 && port <= 65535 ? 1 : 0) != 0, (String)"'%s' port value %s is out of range. Port must be between 1 and 65535.", (Object)key, (int)port);
            }
            catch (Exception ex) {
                throw new ConfigException(String.format("'%s' is not a valid hostname and port.", key), (Object)ex);
            }
        } else if (value instanceof List) {
            List list = (List)value;
            for (String s : list) {
                this.ensureValid(key, s);
            }
        } else {
            throw new ConfigException(String.format("'%s' must be a string or a list.", key));
        }
    }

    public static ValidHostnameAndPort of() {
        return new ValidHostnameAndPort();
    }
}

