/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.data.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.jcustenborder.kafka.connect.utils.data.type.TypeParser;
import com.google.common.base.Preconditions;
import org.apache.kafka.connect.data.Schema;

public class Int32TypeParser
implements TypeParser {
    @Override
    public Object parseString(String s, Schema schema) {
        return Integer.parseInt(s);
    }

    @Override
    public Class<?> expectedClass() {
        return Integer.class;
    }

    @Override
    public Object parseJsonNode(JsonNode input, Schema schema) {
        Preconditions.checkState((boolean)input.isInt(), (String)"'%s' is not a '%s'", (Object[])new Object[]{input.textValue(), this.expectedClass().getSimpleName()});
        return input.intValue();
    }
}

