/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.config;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.File;
import org.apache.kafka.common.config.AbstractConfig;

public class ConfigUtils {
    private ConfigUtils() {
    }

    public static <T> Class<T> getClass(AbstractConfig config, String key, Class<T> expected) {
        Preconditions.checkNotNull((Object)config, (Object)"config cannot be null");
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
        Preconditions.checkNotNull(expected, (Object)"expected cannot be null");
        Class cls = config.getClass(key);
        Preconditions.checkState((boolean)expected.isAssignableFrom(cls), (String)"'%s' is not assignable from '%s'", (Object[])new Object[]{expected.getSimpleName(), cls.getSimpleName()});
        return cls;
    }

    public static <T extends Enum<T>> T getEnum(Class<T> enumClass, AbstractConfig config, String key) {
        Preconditions.checkNotNull(enumClass, (Object)"enumClass cannot be null");
        Preconditions.checkState((boolean)enumClass.isEnum(), (Object)"enumClass must be an enum.");
        String textValue = config.getString(key);
        return Enum.valueOf(enumClass, textValue);
    }

    public static String enumValues(Class<?> enumClass) {
        Preconditions.checkNotNull(enumClass, (Object)"enumClass cannot be null");
        Preconditions.checkState((boolean)enumClass.isEnum(), (Object)"enumClass must be an enum.");
        return Joiner.on((String)", ").join((Object[])enumClass.getEnumConstants());
    }

    public static File getAbsoluteFile(AbstractConfig config, String key) {
        Preconditions.checkNotNull((Object)config, (Object)"config cannot be null");
        String path = config.getString(key);
        File file = new File(path);
        Preconditions.checkState((boolean)file.isAbsolute(), (String)"'%s' must be an absolute path.", (Object[])new Object[]{key});
        return new File(path);
    }
}

