/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.github.jcustenborder.kafka.connect.utils.templates.Plugin;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Plugin.ConfigProviderExampleInput", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableConfigProviderExampleInput
implements Plugin.ConfigProviderExampleInput {
    @Nullable
    private final String config;
    private final Plugin.ConfigProviderExample example;
    private final String connectorConfig;

    private ImmutableConfigProviderExampleInput(@Nullable String config, Plugin.ConfigProviderExample example, String connectorConfig) {
        this.config = config;
        this.example = example;
        this.connectorConfig = connectorConfig;
    }

    @Override
    @Nullable
    public String getConfig() {
        return this.config;
    }

    @Override
    public Plugin.ConfigProviderExample getExample() {
        return this.example;
    }

    @Override
    public String getConnectorConfig() {
        return this.connectorConfig;
    }

    public final ImmutableConfigProviderExampleInput withConfig(@Nullable String value) {
        if (Objects.equals(this.config, value)) {
            return this;
        }
        return new ImmutableConfigProviderExampleInput(value, this.example, this.connectorConfig);
    }

    public final ImmutableConfigProviderExampleInput withExample(Plugin.ConfigProviderExample value) {
        if (this.example == value) {
            return this;
        }
        Plugin.ConfigProviderExample newValue = Objects.requireNonNull(value, "example");
        return new ImmutableConfigProviderExampleInput(this.config, newValue, this.connectorConfig);
    }

    public final ImmutableConfigProviderExampleInput withConnectorConfig(String value) {
        String newValue = Objects.requireNonNull(value, "connectorConfig");
        if (this.connectorConfig.equals(newValue)) {
            return this;
        }
        return new ImmutableConfigProviderExampleInput(this.config, this.example, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConfigProviderExampleInput && this.equalTo((ImmutableConfigProviderExampleInput)another);
    }

    private boolean equalTo(ImmutableConfigProviderExampleInput another) {
        return Objects.equals(this.config, another.config) && this.example.equals(another.example) && this.connectorConfig.equals(another.connectorConfig);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.config);
        h += (h << 5) + this.example.hashCode();
        h += (h << 5) + this.connectorConfig.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ConfigProviderExampleInput").omitNullValues().add("config", (Object)this.config).add("example", (Object)this.example).add("connectorConfig", (Object)this.connectorConfig).toString();
    }

    public static ImmutableConfigProviderExampleInput copyOf(Plugin.ConfigProviderExampleInput instance) {
        if (instance instanceof ImmutableConfigProviderExampleInput) {
            return (ImmutableConfigProviderExampleInput)instance;
        }
        return ImmutableConfigProviderExampleInput.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Plugin.ConfigProviderExampleInput", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_EXAMPLE = 1L;
        private static final long INIT_BIT_CONNECTOR_CONFIG = 2L;
        private long initBits = 3L;
        @Nullable
        private String config;
        @Nullable
        private Plugin.ConfigProviderExample example;
        @Nullable
        private String connectorConfig;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Plugin.ConfigProviderExampleInput instance) {
            Objects.requireNonNull(instance, "instance");
            String configValue = instance.getConfig();
            if (configValue != null) {
                this.config(configValue);
            }
            this.example((Plugin.ConfigProviderExample)instance.getExample());
            this.connectorConfig(instance.getConnectorConfig());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder config(@Nullable String config) {
            this.config = config;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder example(Plugin.ConfigProviderExample example) {
            this.example = Objects.requireNonNull(example, "example");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder connectorConfig(String connectorConfig) {
            this.connectorConfig = Objects.requireNonNull(connectorConfig, "connectorConfig");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableConfigProviderExampleInput build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConfigProviderExampleInput(this.config, this.example, this.connectorConfig);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("example");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("connectorConfig");
            }
            return "Cannot build ConfigProviderExampleInput, some of required attributes are not set " + attributes;
        }
    }
}

