/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.github.jcustenborder.kafka.connect.utils.config.Description;
import com.github.jcustenborder.kafka.connect.utils.config.DocumentationDanger;
import com.github.jcustenborder.kafka.connect.utils.config.DocumentationImportant;
import com.github.jcustenborder.kafka.connect.utils.config.DocumentationNote;
import com.github.jcustenborder.kafka.connect.utils.config.DocumentationSections;
import com.github.jcustenborder.kafka.connect.utils.config.DocumentationTip;
import com.github.jcustenborder.kafka.connect.utils.config.DocumentationWarning;
import com.github.jcustenborder.kafka.connect.utils.config.Icon;
import com.github.jcustenborder.kafka.connect.utils.config.Introduction;
import com.github.jcustenborder.kafka.connect.utils.config.PluginName;
import com.github.jcustenborder.kafka.connect.utils.config.PluginOwner;
import com.github.jcustenborder.kafka.connect.utils.config.Title;
import com.github.jcustenborder.kafka.connect.utils.templates.ImmutableSection;
import com.github.jcustenborder.kafka.connect.utils.templates.Notes;
import com.google.common.base.CaseFormat;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

class AnnotationHelper {
    AnnotationHelper() {
    }

    private static String description(Class<?> c) {
        Description description = c.getAnnotation(Description.class);
        return null != description ? description.value() : null;
    }

    private static String title(Class<?> c) {
        Title annotation = c.getAnnotation(Title.class);
        return null != annotation ? annotation.value() : c.getSimpleName();
    }

    private static String danger(Class<?> c) {
        DocumentationDanger annotation = c.getAnnotation(DocumentationDanger.class);
        return null != annotation ? annotation.value() : null;
    }

    private static String important(Class<?> c) {
        DocumentationImportant annotation = c.getAnnotation(DocumentationImportant.class);
        return null != annotation ? annotation.value() : null;
    }

    private static String tip(Class<?> c) {
        DocumentationTip annotation = c.getAnnotation(DocumentationTip.class);
        return null != annotation ? annotation.value() : null;
    }

    private static String note(Class<?> c) {
        DocumentationNote annotation = c.getAnnotation(DocumentationNote.class);
        return null != annotation ? annotation.value() : null;
    }

    private static String warning(Class<?> c) {
        DocumentationWarning annotation = c.getAnnotation(DocumentationWarning.class);
        return null != annotation ? annotation.value() : null;
    }

    private static String introduction(Package p) {
        Introduction annotation = p.getAnnotation(Introduction.class);
        return null != annotation ? annotation.value() : null;
    }

    private static String danger(Package p) {
        DocumentationDanger annotation = p.getAnnotation(DocumentationDanger.class);
        return null != annotation ? annotation.value() : null;
    }

    private static String important(Package p) {
        DocumentationImportant annotation = p.getAnnotation(DocumentationImportant.class);
        return null != annotation ? annotation.value() : null;
    }

    private static String tip(Package p) {
        DocumentationTip annotation = p.getAnnotation(DocumentationTip.class);
        return null != annotation ? annotation.value() : null;
    }

    private static String note(Package p) {
        DocumentationNote annotation = p.getAnnotation(DocumentationNote.class);
        return null != annotation ? annotation.value() : null;
    }

    private static String warning(Package p) {
        DocumentationWarning annotation = p.getAnnotation(DocumentationWarning.class);
        return null != annotation ? annotation.value() : null;
    }

    private static String title(Package p) {
        Title annotation = p.getAnnotation(Title.class);
        return null != annotation ? annotation.value() : CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, p.getName());
    }

    public static String pluginOwner(Package p) {
        PluginOwner annotation = p.getAnnotation(PluginOwner.class);
        return null != annotation ? annotation.value() : null;
    }

    public static String pluginName(Package p) {
        PluginName annotation = p.getAnnotation(PluginName.class);
        return null != annotation ? annotation.value() : null;
    }

    private static String icon(Package p) {
        Icon annotation = p.getAnnotation(Icon.class);
        return null != annotation ? annotation.path() : null;
    }

    private static String icon(Class<?> c) {
        Icon annotation = c.getAnnotation(Icon.class);
        return null != annotation ? annotation.path() : null;
    }

    public static Notes notes(Class<?> c) {
        return new AnnotatedNotes(c);
    }

    public static Notes notes(Package p) {
        return new AnnotatedNotes(p);
    }

    static class AnnotatedNotes
    extends AnnotationReader
    implements Notes {
        protected AnnotatedNotes(AnnotatedElement annotatedElement) {
            super(annotatedElement);
        }

        @Override
        @Nullable
        public String getWarning() {
            return this.getValue(DocumentationWarning.class, DocumentationWarning::value);
        }

        @Override
        @Nullable
        public String getTip() {
            return this.getValue(DocumentationTip.class, DocumentationTip::value);
        }

        @Override
        @Nullable
        public String getImportant() {
            return this.getValue(DocumentationImportant.class, DocumentationImportant::value);
        }

        @Override
        @Nullable
        public String getDanger() {
            return this.getValue(DocumentationDanger.class, DocumentationDanger::value);
        }

        @Override
        @Nullable
        public String getNote() {
            return this.getValue(DocumentationNote.class, DocumentationNote::value);
        }

        @Override
        @Nullable
        public String getTitle() {
            if (this.annotatedElement instanceof Class) {
                Class o = (Class)this.annotatedElement;
                return AnnotationHelper.title(o);
            }
            if (this.annotatedElement instanceof Package) {
                Package o = (Package)this.annotatedElement;
                return AnnotationHelper.title(o);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.getValue(Description.class, Description::value);
        }

        @Override
        @Nullable
        public String getIcon() {
            return this.getValue(Icon.class, Icon::path);
        }

        @Override
        @Nullable
        public String getIntroduction() {
            return this.getValue(Introduction.class, Introduction::value);
        }

        @Override
        public List<Notes.Section> getSections() {
            ArrayList sections = this.getValue(DocumentationSections.class, documentationSections -> Stream.of(documentationSections.sections()).map(s -> ImmutableSection.builder().title(s.title()).text(s.text()).build()).collect(Collectors.toList()));
            if (null == sections) {
                sections = new ArrayList();
            }
            return sections;
        }
    }

    static abstract class AnnotationReader {
        final AnnotatedElement annotatedElement;

        protected AnnotationReader(AnnotatedElement annotatedElement) {
            this.annotatedElement = annotatedElement;
        }

        protected <T extends Annotation, U> U getValue(Class<T> cls, Function<T, U> function) {
            T annotation = this.annotatedElement.getAnnotation(cls);
            U result = null != annotation ? (U)function.apply(annotation) : null;
            return result;
        }
    }
}

