/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils;

import com.github.jcustenborder.kafka.connect.utils.AssertSchema;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Struct;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.google.common.base.Strings;
import shaded.com.google.common.io.BaseEncoding;

public class AssertStruct {
    private static final Logger log = LoggerFactory.getLogger(AssertStruct.class);

    static <T> T castAndVerify(Class<T> cls, Struct struct, Field field, boolean expected) {
        Object value = struct.get(field.name());
        String prefix = String.format("%s('%s') ", expected ? "expected" : "actual", field.name());
        if (!field.schema().isOptional()) {
            Assertions.assertNotNull((Object)value, (String)(prefix + "has a require schema. Should not be null."));
        }
        if (null == value) {
            return null;
        }
        Assertions.assertTrue((boolean)cls.isInstance(value), (String)String.format(prefix + "should be a %s", cls.getSimpleName()));
        return cls.cast(value);
    }

    public static void assertStruct(Struct expected, Struct actual, String message) {
        String prefix;
        String string = prefix = Strings.isNullOrEmpty((String)message) ? "" : message + ": ";
        if (null == expected) {
            Assertions.assertNull((Object)actual, (String)(prefix + "actual should be null."));
            return;
        }
        AssertSchema.assertSchema(expected.schema(), actual.schema(), "schema does not match.");
        block6: for (Field expectedField : expected.schema().fields()) {
            log.trace("assertStruct() - testing field '{}'", (Object)expectedField.name());
            Object expectedValue = expected.get(expectedField.name());
            Object actualValue = actual.get(expectedField.name());
            if ("org.apache.kafka.connect.data.Decimal".equals(expectedField.schema().name())) {
                BigDecimal expectedDecimal = AssertStruct.castAndVerify(BigDecimal.class, expected, expectedField, true);
                BigDecimal actualDecimal = AssertStruct.castAndVerify(BigDecimal.class, actual, expectedField, false);
                Assertions.assertEquals((Object)expectedDecimal, (Object)actualDecimal, (String)(prefix + expectedField.name() + " does not match."));
                continue;
            }
            if ("org.apache.kafka.connect.data.Timestamp".equals(expectedField.schema().name()) || "org.apache.kafka.connect.data.Date".equals(expectedField.schema().name()) || "org.apache.kafka.connect.data.Time".equals(expectedField.schema().name())) {
                Date expectedDate = AssertStruct.castAndVerify(Date.class, expected, expectedField, true);
                Date actualDate = AssertStruct.castAndVerify(Date.class, actual, expectedField, false);
                Assertions.assertEquals((Object)expectedDate, (Object)actualDate, (String)(prefix + expectedField.name() + " does not match."));
                continue;
            }
            switch (expectedField.schema().type()) {
                case ARRAY: {
                    List expectedArray = AssertStruct.castAndVerify(List.class, expected, expectedField, true);
                    List actualArray = AssertStruct.castAndVerify(List.class, actual, expectedField, false);
                    Assertions.assertEquals((Object)expectedArray, (Object)actualArray, (String)(prefix + expectedField.name() + " does not match."));
                    continue block6;
                }
                case MAP: {
                    Map expectedMap = AssertStruct.castAndVerify(Map.class, expected, expectedField, true);
                    Map actualMap = AssertStruct.castAndVerify(Map.class, actual, expectedField, false);
                    Assertions.assertEquals((Object)expectedMap, (Object)actualMap, (String)(prefix + expectedField.name() + " does not match."));
                    continue block6;
                }
                case STRUCT: {
                    Struct expectedStruct = AssertStruct.castAndVerify(Struct.class, expected, expectedField, true);
                    Struct actualStruct = AssertStruct.castAndVerify(Struct.class, actual, expectedField, false);
                    AssertStruct.assertStruct(expectedStruct, actualStruct, prefix + expectedField.name() + " does not match.");
                    continue block6;
                }
                case BYTES: {
                    byte[] expectedByteArray = AssertStruct.castAndVerify(byte[].class, expected, expectedField, true);
                    byte[] actualByteArray = AssertStruct.castAndVerify(byte[].class, actual, expectedField, false);
                    Assertions.assertEquals((Object)(null == expectedByteArray ? "" : BaseEncoding.base32Hex().encode(expectedByteArray).toString()), (Object)(null == actualByteArray ? "" : BaseEncoding.base32Hex().encode(actualByteArray).toString()), (String)(prefix + expectedField.name() + " does not match."));
                    continue block6;
                }
            }
            Assertions.assertEquals((Object)expectedValue, (Object)actualValue, (String)(prefix + expectedField.name() + " does not match."));
        }
    }

    public static void assertStruct(Struct expected, Struct actual) {
        AssertStruct.assertStruct(expected, actual, null);
    }
}

