/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.github.jcustenborder.kafka.connect.utils.templates.Plugin;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Plugin.SourceConnectorExampleInput", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableSourceConnectorExampleInput
implements Plugin.SourceConnectorExampleInput {
    @Nullable
    private final String config;
    private final Plugin.SourceConnectorExample example;
    @Nullable
    private final String outputJson;
    @Nullable
    private final String outputDescription;

    private ImmutableSourceConnectorExampleInput(@Nullable String config, Plugin.SourceConnectorExample example, @Nullable String outputJson, @Nullable String outputDescription) {
        this.config = config;
        this.example = example;
        this.outputJson = outputJson;
        this.outputDescription = outputDescription;
    }

    @Override
    @Nullable
    public String getConfig() {
        return this.config;
    }

    @Override
    public Plugin.SourceConnectorExample getExample() {
        return this.example;
    }

    @Override
    @Nullable
    public String getOutputJson() {
        return this.outputJson;
    }

    @Override
    @Nullable
    public String getOutputDescription() {
        return this.outputDescription;
    }

    public final ImmutableSourceConnectorExampleInput withConfig(@Nullable String value) {
        if (Objects.equals(this.config, value)) {
            return this;
        }
        return new ImmutableSourceConnectorExampleInput(value, this.example, this.outputJson, this.outputDescription);
    }

    public final ImmutableSourceConnectorExampleInput withExample(Plugin.SourceConnectorExample value) {
        if (this.example == value) {
            return this;
        }
        Plugin.SourceConnectorExample newValue = Objects.requireNonNull(value, "example");
        return new ImmutableSourceConnectorExampleInput(this.config, newValue, this.outputJson, this.outputDescription);
    }

    public final ImmutableSourceConnectorExampleInput withOutputJson(@Nullable String value) {
        if (Objects.equals(this.outputJson, value)) {
            return this;
        }
        return new ImmutableSourceConnectorExampleInput(this.config, this.example, value, this.outputDescription);
    }

    public final ImmutableSourceConnectorExampleInput withOutputDescription(@Nullable String value) {
        if (Objects.equals(this.outputDescription, value)) {
            return this;
        }
        return new ImmutableSourceConnectorExampleInput(this.config, this.example, this.outputJson, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSourceConnectorExampleInput && this.equalTo((ImmutableSourceConnectorExampleInput)another);
    }

    private boolean equalTo(ImmutableSourceConnectorExampleInput another) {
        return Objects.equals(this.config, another.config) && this.example.equals(another.example) && Objects.equals(this.outputJson, another.outputJson) && Objects.equals(this.outputDescription, another.outputDescription);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.config);
        h += (h << 5) + this.example.hashCode();
        h += (h << 5) + Objects.hashCode(this.outputJson);
        h += (h << 5) + Objects.hashCode(this.outputDescription);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SourceConnectorExampleInput").omitNullValues().add("config", (Object)this.config).add("example", (Object)this.example).add("outputJson", (Object)this.outputJson).add("outputDescription", (Object)this.outputDescription).toString();
    }

    public static ImmutableSourceConnectorExampleInput copyOf(Plugin.SourceConnectorExampleInput instance) {
        if (instance instanceof ImmutableSourceConnectorExampleInput) {
            return (ImmutableSourceConnectorExampleInput)instance;
        }
        return ImmutableSourceConnectorExampleInput.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Plugin.SourceConnectorExampleInput", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_EXAMPLE = 1L;
        private long initBits = 1L;
        @Nullable
        private String config;
        @Nullable
        private Plugin.SourceConnectorExample example;
        @Nullable
        private String outputJson;
        @Nullable
        private String outputDescription;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Plugin.SourceConnectorExampleInput instance) {
            String outputDescriptionValue;
            Objects.requireNonNull(instance, "instance");
            String configValue = instance.getConfig();
            if (configValue != null) {
                this.config(configValue);
            }
            this.example(instance.getExample());
            String outputJsonValue = instance.getOutputJson();
            if (outputJsonValue != null) {
                this.outputJson(outputJsonValue);
            }
            if ((outputDescriptionValue = instance.getOutputDescription()) != null) {
                this.outputDescription(outputDescriptionValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder config(@Nullable String config) {
            this.config = config;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder example(Plugin.SourceConnectorExample example) {
            this.example = Objects.requireNonNull(example, "example");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder outputJson(@Nullable String outputJson) {
            this.outputJson = outputJson;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder outputDescription(@Nullable String outputDescription) {
            this.outputDescription = outputDescription;
            return this;
        }

        public ImmutableSourceConnectorExampleInput build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSourceConnectorExampleInput(this.config, this.example, this.outputJson, this.outputDescription);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("example");
            }
            return "Cannot build SourceConnectorExampleInput, some of required attributes are not set " + attributes;
        }
    }
}

