/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates.markdown;

import com.github.jcustenborder.kafka.connect.utils.templates.Table;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MarkdownTemplateHelper {
    static void lengths(List<Integer> lengths, List<List<String>> rows) {
        if (lengths.isEmpty()) {
            for (int i = 0; i < rows.get(0).size(); ++i) {
                lengths.add(0);
            }
        }
        for (List<String> row : rows) {
            for (int i = 0; i < row.size(); ++i) {
                int previous = lengths.get(i);
                int current = Strings.isNullOrEmpty((String)row.get(i)) ? 0 : row.get(i).length();
                int value = Math.max(current, previous);
                lengths.set(i, value);
            }
        }
    }

    public String table(Table table) {
        StringBuilder builder = new StringBuilder();
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        MarkdownTemplateHelper.lengths(lengths, Arrays.asList(table.getHeaders()));
        MarkdownTemplateHelper.lengths(lengths, table.getRowData());
        int index = 0;
        ArrayList<String> rowData = new ArrayList<String>(lengths.size());
        for (String string : table.getHeaders()) {
            int length = (Integer)lengths.get(index);
            String text = Strings.padEnd((String)string, (int)length, (char)' ');
            rowData.add(text);
            ++index;
        }
        builder.append("| ");
        builder.append(Joiner.on((String)" | ").join(rowData));
        builder.append("|\n");
        rowData.clear();
        for (Integer n : lengths) {
            rowData.add(Strings.repeat((String)"-", (int)n));
        }
        builder.append("| ");
        builder.append(Joiner.on((String)" | ").join(rowData));
        builder.append("|\n");
        for (List list : table.getRowData()) {
            index = 0;
            rowData.clear();
            for (String columnData : list) {
                int length = (Integer)lengths.get(index);
                String text = Strings.padEnd((String)columnData, (int)length, (char)' ');
                rowData.add(text);
                ++index;
            }
            builder.append("| ");
            builder.append(Joiner.on((String)" | ").join(rowData));
            builder.append("|\n");
            ++index;
        }
        return builder.toString();
    }
}

