/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import org.apache.kafka.common.config.ConfigDef;

public class TemplateConfigEntry {
    private final String name;
    private final String importance;
    private final String doc;
    private final String defaultValue;
    private final String validator;
    private final String type;
    private final boolean isRequired;
    private final String group;

    private TemplateConfigEntry(String name, ConfigDef.Importance importance, String doc, Object defaultValue, ConfigDef.Validator validator, ConfigDef.Type type, boolean isRequired, String group) {
        this.name = name;
        this.importance = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, importance.toString());
        this.doc = !Strings.isNullOrEmpty((String)doc) ? doc : "";
        this.defaultValue = null != defaultValue && ConfigDef.NO_DEFAULT_VALUE != defaultValue ? defaultValue.toString() : "";
        this.validator = null != validator ? validator.toString() : "";
        this.type = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, type.toString());
        this.isRequired = isRequired;
        this.group = group;
    }

    public static TemplateConfigEntry of(ConfigDef.ConfigKey configKey) {
        return new TemplateConfigEntry(configKey.name, configKey.importance, configKey.documentation, configKey.defaultValue, configKey.validator, configKey.type, !configKey.hasDefault(), configKey.group);
    }

    public String getName() {
        return this.name;
    }

    public String getImportance() {
        return this.importance;
    }

    public String getDoc() {
        return this.doc;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getValidator() {
        return this.validator;
    }

    public String getType() {
        return this.type;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean isRequired() {
        return this.isRequired;
    }
}

