/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.github.jcustenborder.kafka.connect.utils.templates.Table;
import com.github.jcustenborder.kafka.connect.utils.templates.TemplateConfigEntry;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;

public class TemplateConfigDef
implements Table {
    final List<TemplateConfigEntry> configs;

    private TemplateConfigDef(List<TemplateConfigEntry> configs) {
        this.configs = ImmutableList.copyOf(configs);
    }

    @Override
    public String getTitle() {
        return "Configuration";
    }

    @Override
    public List<String> getHeaders() {
        return Arrays.asList("Name", "Type", "Importance", "Default Value", "Validator", "Documentation");
    }

    @Override
    public List<List<String>> getRowData() {
        ArrayList<ImmutableList> result = new ArrayList<ImmutableList>(this.configs.size());
        for (TemplateConfigEntry entry : this.configs) {
            result.add(ImmutableList.of((Object)entry.getName(), (Object)entry.getType(), (Object)entry.getImportance(), (Object)entry.getDefaultValue(), (Object)entry.getValidator(), (Object)entry.getDoc()));
        }
        return ImmutableList.copyOf(result);
    }

    public List<TemplateConfigEntry> getConfigs() {
        return this.configs;
    }

    public List<TemplateConfigEntry> getRequiredConfigs() {
        return this.configs.stream().filter(entry -> entry.isRequired()).collect(Collectors.toList());
    }

    public static TemplateConfigDef from(ConfigDef config) {
        List<TemplateConfigEntry> configs = config.configKeys().entrySet().stream().sorted((k1, k2) -> {
            if (!((ConfigDef.ConfigKey)k1.getValue()).hasDefault() && ((ConfigDef.ConfigKey)k2.getValue()).hasDefault()) {
                return -1;
            }
            if (!((ConfigDef.ConfigKey)k2.getValue()).hasDefault() && ((ConfigDef.ConfigKey)k1.getValue()).hasDefault()) {
                return 1;
            }
            int cmp = ((ConfigDef.ConfigKey)k1.getValue()).importance.compareTo((Enum)((ConfigDef.ConfigKey)k2.getValue()).importance);
            if (cmp == 0) {
                return ((ConfigDef.ConfigKey)k1.getValue()).name.compareTo(((ConfigDef.ConfigKey)k2.getValue()).name);
            }
            return cmp;
        }).map(entry -> TemplateConfigEntry.of((ConfigDef.ConfigKey)entry.getValue())).collect(Collectors.toList());
        return new TemplateConfigDef(configs);
    }
}

