/*
 * Decompiled with CFR 0.152.
 */
package com.fenchtose.tooltip;

import android.animation.Animator;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class TooltipAnimation {
    public static final int NONE = 0;
    public static final int FADE = 1;
    public static final int REVEAL = 2;
    public static final int SCALE = 3;
    public static final int SCALE_AND_FADE = 4;
    private int type;
    private static final int DEFAULT_TYPE = 1;
    private static final int DEFAULT_DURATION = 400;
    private int duration;
    private boolean hideContentWhenAnimating;

    public TooltipAnimation(int type, int duration) {
        this(type, duration, false);
    }

    public TooltipAnimation(int type, int duration, boolean hideContentWhenAnimating) {
        this.type = type;
        this.duration = duration;
        this.hideContentWhenAnimating = hideContentWhenAnimating;
    }

    public TooltipAnimation(int type) {
        this(type, 400);
    }

    public TooltipAnimation() {
        this(1, 400);
    }

    public int getType() {
        return this.type;
    }

    public int getDuration() {
        return this.duration;
    }

    void hideContentWhenAnimatingIn(final @NonNull Animator animator, final @NonNull View contentView) {
        if (this.hideContentWhenAnimating && contentView instanceof ViewGroup) {
            TooltipAnimation.hideAllChildren((ViewGroup)contentView);
            animator.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    TooltipAnimation.showAllChildren((ViewGroup)contentView);
                    animator.removeListener((Animator.AnimatorListener)this);
                }

                public void onAnimationCancel(Animator animation) {
                    TooltipAnimation.showAllChildren((ViewGroup)contentView);
                    animator.removeListener((Animator.AnimatorListener)this);
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        }
    }

    void hideContentWhenAnimatingOut(@NonNull View contentView) {
        if (this.hideContentWhenAnimating && contentView instanceof ViewGroup) {
            TooltipAnimation.hideAllChildren((ViewGroup)contentView);
        }
    }

    private static void hideAllChildren(@NonNull ViewGroup view) {
        for (int i = 0; i < view.getChildCount(); ++i) {
            view.getChildAt(i).setVisibility(4);
        }
    }

    private static void showAllChildren(@NonNull ViewGroup view) {
        for (int i = 0; i < view.getChildCount(); ++i) {
            view.getChildAt(i).setVisibility(0);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

