/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit.http;

import ando.toolkit.AppUtils;
import ando.toolkit.ShellUtils;
import ando.toolkit.http.NetworkUtils;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.text.format.Formatter;
import android.util.Log;
import androidx.annotation.RequiresPermission;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u000e\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u0004\u0018\u00010\nJ\u0012\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0006\u0010\u0018\u001a\u00020\nJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u001cH\u0002J\u0006\u0010 \u001a\u00020\nJ\u0006\u0010!\u001a\u00020\u0012J\u0006\u0010\"\u001a\u00020\u0012J\u0006\u0010#\u001a\u00020\u0012J\u0006\u0010$\u001a\u00020\u0012J\u0010\u0010$\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\nJ\u0006\u0010%\u001a\u00020\u0012J\u000e\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\nJ\u0006\u0010'\u001a\u00020\u0012J\b\u0010(\u001a\u00020\u0012H\u0002J\u0006\u0010)\u001a\u00020\u0012J\u0006\u0010*\u001a\u00020\u0012J\u0006\u0010+\u001a\u00020\u0012J\u0006\u0010,\u001a\u00020\u0012J\u0006\u0010-\u001a\u00020\u0012J\u0006\u0010.\u001a\u00020\u0012J\b\u0010/\u001a\u00020\u0012H\u0007J\u0006\u00100\u001a\u00020\nJ\u0006\u00101\u001a\u00020\nJ\u000e\u00102\u001a\u0002032\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u00104\u001a\u00020\nJ\u0010\u00105\u001a\u0002032\u0006\u00106\u001a\u00020\u0012H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00068"}, d2={"Lando/toolkit/http/NetworkUtils;", "", "()V", "sConnectivityManager", "Landroid/net/ConnectivityManager;", "getSConnectivityManager", "()Landroid/net/ConnectivityManager;", "sConnectivityManager$delegate", "Lkotlin/Lazy;", "broadcastIpAddress", "", "gatewayByWifi", "getActiveNetworkInfo", "Landroid/net/NetworkInfo;", "getDomainAddress", "domain", "getIPAddress", "useIPv4", "", "getMac", "context", "Landroid/content/Context;", "getMacAddress", "getMacDefault", "getMacFromHardware", "getNetworkType", "Lando/toolkit/http/NetworkUtils$NetworkType;", "getWifiRSSI", "", "getWifiSSID", "intToIp", "ipAddress", "ipAddressByWifi", "is4G", "is5G", "isAvailable", "isAvailableByDns", "isAvailableByPing", "ip", "isConnected", "isEthernet", "isMobile", "isMobileEnabled", "isNetworkOnline", "isWifi", "isWifiAvailable", "isWifiConnected", "isWifiEnabled", "netMaskByWifi", "networkOperatorName", "openWirelessSettings", "", "serverAddressByWifi", "setWifiEnabled", "enabled", "NetworkType", "ando_toolkit_release"})
public final class NetworkUtils {
    @NotNull
    public static final NetworkUtils INSTANCE = new NetworkUtils();
    @NotNull
    private static final Lazy sConnectivityManager$delegate = LazyKt.lazy((Function0)sConnectivityManager.2.INSTANCE);

    private NetworkUtils() {
    }

    @NotNull
    public final ConnectivityManager getSConnectivityManager() {
        Lazy lazy = sConnectivityManager$delegate;
        boolean bl = false;
        return (ConnectivityManager)lazy.getValue();
    }

    @Nullable
    public final NetworkInfo getActiveNetworkInfo() {
        return this.getSConnectivityManager().getActiveNetworkInfo();
    }

    public final void openWirelessSettings(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.startActivity(new Intent("android.settings.WIRELESS_SETTINGS").setFlags(0x10000000));
    }

    public final boolean isConnected() {
        NetworkInfo info = this.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }

    public final boolean isAvailable() {
        return this.isAvailableByDns() || this.isAvailableByPing("");
    }

    public final boolean isAvailableByPing() {
        return this.isAvailableByPing("");
    }

    public final boolean isAvailableByPing(@NotNull String ip) {
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        String realIp = TextUtils.isEmpty((CharSequence)ip) ? "223.5.5.5" : ip;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "ping -c 1 %s";
        Object[] objectArray = new Object[]{realIp};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        ShellUtils.CommandResult result = ShellUtils.INSTANCE.execCmd(string2, false);
        return result.getResult() == 0;
    }

    public final boolean isAvailableByDns() {
        return this.isAvailableByDns("");
    }

    public final boolean isAvailableByDns(@Nullable String domain) {
        CharSequence charSequence = domain;
        boolean bl = false;
        boolean bl2 = false;
        String realDomain = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "www.baidu.com" : domain;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(realDomain);
            return inetAddress != null;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return false;
        }
    }

    public final boolean isNetworkOnline() {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process ipProcess = runtime.exec("ping -c 3 www.baidu.com");
            int exitValue = ipProcess.waitFor();
            if (AppUtils.INSTANCE.isDebug()) {
                Log.i((String)"\u901a\u77e5", (String)Intrinsics.stringPlus((String)"Avalible Process:", (Object)exitValue));
            }
            return exitValue == 0;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return false;
    }

    public final boolean isMobileEnabled() {
        try {
            Object object = AppUtils.INSTANCE.getContext().getSystemService("phone");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
            }
            TelephonyManager tm = (TelephonyManager)object;
            if (Build.VERSION.SDK_INT >= 26) {
                return tm.isDataEnabled();
            }
            Method getMobileDataEnabledMethod = tm.getClass().getDeclaredMethod("getDataEnabled", new Class[0]);
            Object object2 = getMobileDataEnabledMethod.invoke((Object)tm, new Object[0]);
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
            }
            return (Boolean)object2;
        }
        catch (Exception e) {
            Log.e((String)"NetworkUtils", (String)"getMobileDataEnabled: ", (Throwable)e);
            return false;
        }
    }

    public final boolean isMobile() {
        NetworkInfo info = this.getActiveNetworkInfo();
        return info != null && info.isAvailable() && info.getType() == 0;
    }

    public final boolean is4G() {
        NetworkInfo info = this.getActiveNetworkInfo();
        return info != null && info.isAvailable() && info.getSubtype() == 13;
    }

    public final boolean is5G() {
        NetworkInfo info = this.getActiveNetworkInfo();
        return Build.VERSION.SDK_INT >= 29 ? info != null && info.isAvailable() && info.getSubtype() == 20 : false;
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE"})
    public final boolean isWifiEnabled() {
        Object object = AppUtils.INSTANCE.getApplication().getApplicationContext().getSystemService("wifi");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
        }
        WifiManager manager = (WifiManager)object;
        return manager.isWifiEnabled();
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.CHANGE_WIFI_STATE"})
    public final void setWifiEnabled(boolean enabled) {
        Object object = AppUtils.INSTANCE.getApplication().getApplicationContext().getSystemService("wifi");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
        }
        WifiManager manager = (WifiManager)object;
        if (enabled == manager.isWifiEnabled()) {
            return;
        }
        manager.setWifiEnabled(enabled);
    }

    public final boolean isWifiConnected() {
        NetworkInfo ni = this.getActiveNetworkInfo();
        return ni != null && ni.getType() == 1;
    }

    public final boolean isWifiAvailable() {
        return this.isWifiEnabled() && this.isAvailable();
    }

    @NotNull
    public final String networkOperatorName() {
        Object object = AppUtils.INSTANCE.getContext().getSystemService("phone");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        String string = ((TelephonyManager)object).getNetworkOperatorName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContext().getSystemService(Context.TELEPHONY_SERVICE) as TelephonyManager).networkOperatorName");
        return string;
    }

    @NotNull
    public final NetworkType getNetworkType() {
        NetworkType networkType;
        if (this.isEthernet()) {
            return NetworkType.NETWORK_ETHERNET;
        }
        NetworkInfo networkInfo = this.getActiveNetworkInfo();
        if (networkInfo == null) {
            return NetworkType.NETWORK_NO;
        }
        NetworkInfo info = networkInfo;
        if (!info.isConnected()) {
            return NetworkType.NETWORK_NO;
        }
        if (info.isAvailable()) {
            int n = info.getType();
            block0 : switch (n) {
                case 1: {
                    networkType = NetworkType.NETWORK_WIFI;
                    break;
                }
                case 0: {
                    int n2 = info.getSubtype();
                    switch (n2) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 11: 
                        case 16: {
                            networkType = NetworkType.NETWORK_2G;
                            break block0;
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 14: 
                        case 15: 
                        case 17: {
                            networkType = NetworkType.NETWORK_3G;
                            break block0;
                        }
                        case 13: 
                        case 18: {
                            networkType = NetworkType.NETWORK_4G;
                            break block0;
                        }
                        case 20: {
                            networkType = NetworkType.NETWORK_5G;
                            break block0;
                        }
                    }
                    String subtypeName = info.getSubtypeName();
                    if (StringsKt.equals((String)"TD-SCDMA", (String)subtypeName, (boolean)true) || StringsKt.equals((String)"WCDMA", (String)subtypeName, (boolean)true) || StringsKt.equals((String)"CDMA2000", (String)subtypeName, (boolean)true)) {
                        networkType = NetworkType.NETWORK_3G;
                        break;
                    }
                    networkType = NetworkType.NETWORK_UNKNOWN;
                    break;
                }
                default: {
                    networkType = NetworkType.NETWORK_UNKNOWN;
                    break;
                }
            }
        } else {
            networkType = NetworkType.NETWORK_NO;
        }
        return networkType;
    }

    private final boolean isEthernet() {
        NetworkInfo networkInfo = this.getSConnectivityManager().getNetworkInfo(9);
        if (networkInfo == null) {
            return false;
        }
        NetworkInfo networkInfo2 = networkInfo;
        NetworkInfo info = networkInfo2;
        if ((networkInfo = info.getState()) == null) {
            return false;
        }
        NetworkInfo state = networkInfo;
        return state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING;
    }

    private final String intToIp(int ipAddress) {
        return "" + (ipAddress & 0xFF) + '.' + (ipAddress >> 8 & 0xFF) + '.' + (ipAddress >> 16 & 0xFF) + '.' + (ipAddress >> 24 & 0xFF);
    }

    @Nullable
    public final String getIPAddress(boolean useIPv4) {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            LinkedList<InetAddress> adds = new LinkedList<InetAddress>();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                if (!ni.isUp() || ni.isLoopback()) continue;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    adds.addFirst(addresses.nextElement());
                }
            }
            for (InetAddress add : adds) {
                String string;
                boolean isIPv4;
                if (add.isLoopbackAddress()) continue;
                String hostAddress = add.getHostAddress();
                Intrinsics.checkNotNullExpressionValue((Object)hostAddress, (String)"hostAddress");
                boolean bl = isIPv4 = StringsKt.indexOf$default((CharSequence)hostAddress, (char)':', (int)0, (boolean)false, (int)6, null) < 0;
                if (useIPv4) {
                    if (!isIPv4) continue;
                    return hostAddress;
                }
                if (isIPv4) continue;
                int index = StringsKt.indexOf$default((CharSequence)hostAddress, (char)'%', (int)0, (boolean)false, (int)6, null);
                if (index < 0) {
                    String string2 = hostAddress;
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                    boolean bl2 = false;
                    String string3 = string2;
                    boolean bl3 = false;
                    String string4 = string3.toUpperCase(locale);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toUpperCase(locale)");
                } else {
                    String string5 = hostAddress;
                    int n = 0;
                    boolean bl4 = false;
                    String string6 = string5.substring(n, index);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string5 = string6;
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                    bl4 = false;
                    String string7 = string5;
                    boolean bl5 = false;
                    String string8 = string7;
                    if (string8 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string9 = string8.toUpperCase(locale);
                    string = string9;
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).toUpperCase(locale)");
                }
                return string;
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return null;
    }

    @NotNull
    public final String broadcastIpAddress() {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                if (!ni.isUp() || ni.isLoopback()) continue;
                List<InterfaceAddress> ias = ni.getInterfaceAddresses();
                int i = 0;
                int size = ias.size();
                while (i < size) {
                    InterfaceAddress ia = ias.get(i);
                    InetAddress broadcast = ia.getBroadcast();
                    if (broadcast != null) {
                        String string = broadcast.getHostAddress();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"broadcast.hostAddress");
                        return string;
                    }
                    int n = i;
                    i = n + 1;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return "";
    }

    @NotNull
    public final String getDomainAddress(@Nullable String domain) {
        String string;
        InetAddress inetAddress = null;
        try {
            InetAddress inetAddress2 = InetAddress.getByName(domain);
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress2, (String)"getByName(domain)");
            inetAddress = inetAddress2;
            string = inetAddress.getHostAddress();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            inetAddress = InetAddress.getByName(domain)\n            inetAddress.hostAddress\n        }");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            string = "";
        }
        return string;
    }

    @NotNull
    public final String ipAddressByWifi() {
        Object object = AppUtils.INSTANCE.getApplication().getApplicationContext().getSystemService("wifi");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
        }
        WifiManager wm = (WifiManager)object;
        object = Formatter.formatIpAddress((int)wm.getDhcpInfo().ipAddress);
        return object == null ? "" : object;
    }

    @NotNull
    public final String gatewayByWifi() {
        Object object = AppUtils.INSTANCE.getApplication().getApplicationContext().getSystemService("wifi");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
        }
        WifiManager wm = (WifiManager)object;
        object = Formatter.formatIpAddress((int)wm.getDhcpInfo().gateway);
        return object == null ? "" : object;
    }

    @NotNull
    public final String netMaskByWifi() {
        Object object = AppUtils.INSTANCE.getApplication().getApplicationContext().getSystemService("wifi");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
        }
        WifiManager wm = (WifiManager)object;
        object = Formatter.formatIpAddress((int)wm.getDhcpInfo().netmask);
        return object == null ? "" : object;
    }

    @NotNull
    public final String serverAddressByWifi() {
        Object object = AppUtils.INSTANCE.getApplication().getApplicationContext().getSystemService("wifi");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
        }
        WifiManager wm = (WifiManager)object;
        object = Formatter.formatIpAddress((int)wm.getDhcpInfo().serverAddress);
        return object == null ? "" : object;
    }

    public final int getWifiRSSI() {
        Object object = AppUtils.INSTANCE.getApplication().getApplicationContext().getSystemService("wifi");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
        }
        WifiManager wifiManager = (WifiManager)object;
        return wifiManager.getConnectionInfo().getRssi();
    }

    @NotNull
    public final String getWifiSSID(@NotNull Context context) {
        NetworkInfo networkInfo;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String ssid = "unknown id";
        if (Build.VERSION.SDK_INT <= 26 || Build.VERSION.SDK_INT == 28) {
            String string;
            Object object = context.getApplicationContext().getSystemService("wifi");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
            }
            WifiManager wifiManager = (WifiManager)object;
            WifiInfo info = wifiManager.getConnectionInfo();
            if (Build.VERSION.SDK_INT < 19) {
                String string2 = info.getSSID();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n                info.ssid\n            }");
                string = string2;
            } else {
                String string3 = info.getSSID();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"info.ssid");
                string = StringsKt.replace$default((String)string3, (String)"\"", (String)"", (boolean)false, (int)4, null);
            }
            return string;
        }
        if (Build.VERSION.SDK_INT == 27 && (networkInfo = this.getActiveNetworkInfo()) != null && networkInfo.isConnected() && networkInfo.getExtraInfo() != null) {
            String string = networkInfo.getExtraInfo();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"networkInfo.extraInfo");
            return StringsKt.replace$default((String)string, (String)"\"", (String)"", (boolean)false, (int)4, null);
        }
        return ssid;
    }

    public final boolean isWifi() {
        NetworkInfo info = this.getActiveNetworkInfo();
        return info != null && info.getType() == 1;
    }

    @Nullable
    public final String getMac(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String mac = "";
        if (Build.VERSION.SDK_INT < 23) {
            mac = this.getMacDefault(context);
        } else if (Build.VERSION.SDK_INT >= 23 && Build.VERSION.SDK_INT < 24) {
            mac = this.getMacAddress();
        } else if (Build.VERSION.SDK_INT >= 24) {
            mac = this.getMacFromHardware();
        }
        return mac;
    }

    @SuppressLint(value={"HardwareIds"})
    @Nullable
    public final String getMacDefault(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String mac = null;
        Object object = context.getApplicationContext().getSystemService("wifi");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
        }
        WifiManager wifi = (WifiManager)object;
        WifiInfo info = null;
        try {
            info = wifi.getConnectionInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (info == null) {
            return null;
        }
        String string = info.getMacAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"info.macAddress");
        mac = string;
        if (!TextUtils.isEmpty((CharSequence)mac)) {
            string = mac;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            boolean bl = false;
            String string2 = string;
            boolean bl2 = false;
            String string3 = string2.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase(locale)");
            mac = string3;
        }
        return mac;
    }

    @Nullable
    public final String getMacAddress() {
        String macSerial = null;
        if (Build.VERSION.SDK_INT == 23 || Build.VERSION.SDK_INT == 24) {
            String str = "";
            try {
                Process pp = Runtime.getRuntime().exec("cat/sys/class/net/wlan0/address");
                InputStreamReader ir = new InputStreamReader(pp.getInputStream());
                LineNumberReader input = new LineNumberReader(ir);
                if (StringsKt.isBlank((CharSequence)str)) {
                    String string = input.readLine();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.readLine()");
                    String $this$trim$iv = str = string;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = $this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    macSerial = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return macSerial;
    }

    @NotNull
    public final String getMacFromHardware() {
        try {
            Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
            while (all.hasMoreElements()) {
                NetworkInterface nif = all.nextElement();
                if (!StringsKt.equals((String)nif.getName(), (String)"wlan0", (boolean)true)) continue;
                byte[] byArray = nif.getHardwareAddress();
                if (byArray == null) {
                    return "";
                }
                byte[] macBytes = byArray;
                StringBuilder res1 = new StringBuilder();
                for (byte b : macBytes) {
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string = "%02X:";
                    Object[] objectArray = new Object[]{b};
                    boolean bl = false;
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                    res1.append(string2);
                }
                if (!TextUtils.isEmpty((CharSequence)res1)) {
                    res1.deleteCharAt(res1.length() - 1);
                }
                String string = res1.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"res1.toString()");
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lando/toolkit/http/NetworkUtils$NetworkType;", "", "(Ljava/lang/String;I)V", "NETWORK_ETHERNET", "NETWORK_WIFI", "NETWORK_5G", "NETWORK_4G", "NETWORK_3G", "NETWORK_2G", "NETWORK_UNKNOWN", "NETWORK_NO", "ando_toolkit_release"})
    public static final class NetworkType
    extends Enum<NetworkType> {
        public static final /* enum */ NetworkType NETWORK_ETHERNET = new NetworkType();
        public static final /* enum */ NetworkType NETWORK_WIFI = new NetworkType();
        public static final /* enum */ NetworkType NETWORK_5G = new NetworkType();
        public static final /* enum */ NetworkType NETWORK_4G = new NetworkType();
        public static final /* enum */ NetworkType NETWORK_3G = new NetworkType();
        public static final /* enum */ NetworkType NETWORK_2G = new NetworkType();
        public static final /* enum */ NetworkType NETWORK_UNKNOWN = new NetworkType();
        public static final /* enum */ NetworkType NETWORK_NO = new NetworkType();
        private static final /* synthetic */ NetworkType[] $VALUES;

        public static NetworkType[] values() {
            return (NetworkType[])$VALUES.clone();
        }

        public static NetworkType valueOf(String value) {
            return Enum.valueOf(NetworkType.class, value);
        }

        static {
            $VALUES = networkTypeArray = new NetworkType[]{NetworkType.NETWORK_ETHERNET, NetworkType.NETWORK_WIFI, NetworkType.NETWORK_5G, NetworkType.NETWORK_4G, NetworkType.NETWORK_3G, NetworkType.NETWORK_2G, NetworkType.NETWORK_UNKNOWN, NetworkType.NETWORK_NO};
        }
    }
}

