/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit;

import ando.toolkit.NotchUtils;
import ando.toolkit.OSUtils;
import ando.toolkit.ext.DeviceUtils;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.core.view.ViewCompat;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002OPB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\nH\u0003J\u0018\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\nH\u0002J\u0018\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\nH\u0002J\u001a\u0010 \u001a\u00020\u00042\b\b\u0001\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0002J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\"\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020\u00042\b\b\u0001\u0010(\u001a\u00020\u0004J\u000e\u0010#\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001cJ\"\u0010#\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010'\u001a\u00020\u00042\b\b\u0001\u0010(\u001a\u00020\u0004J\u0010\u0010)\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&J\u0010\u0010)\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0015\u0010*\u001a\u0004\u0018\u00010\u00042\u0006\u0010+\u001a\u00020,\u00a2\u0006\u0002\u0010-J\u000e\u0010.\u001a\u00020\u00042\u0006\u0010+\u001a\u00020,J\u0010\u0010/\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001cH\u0003J\u0010\u00100\u001a\u00020$2\u0006\u0010+\u001a\u00020,H\u0003J\u000e\u00101\u001a\u00020\n2\u0006\u0010%\u001a\u00020&J\u0018\u00102\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00103\u001a\u000204H\u0003J\u001e\u00105\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u0004J\u0018\u00108\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010!\u001a\u00020\u0004H\u0007J \u00109\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004J\u0010\u0010:\u001a\u00020\n2\b\u0010%\u001a\u0004\u0018\u00010&J\u0018\u0010;\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\u0010<\u001a\u0004\u0018\u00010=J\u0018\u0010>\u001a\u00020\n2\u0006\u0010%\u001a\u00020&2\u0006\u00107\u001a\u00020\u0004H\u0002J\u0010\u0010>\u001a\u00020\n2\b\u0010%\u001a\u0004\u0018\u00010&J\u0018\u0010?\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020\u0004J\u000e\u0010@\u001a\u00020$2\u0006\u0010A\u001a\u00020\u0012J\u000e\u0010B\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0012J\u000e\u0010D\u001a\u00020$2\u0006\u0010E\u001a\u00020FJ\u0018\u0010G\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010H\u001a\u0004\u0018\u00010IJ\u0006\u0010J\u001a\u00020\nJ\b\u0010K\u001a\u00020\nH\u0002J\u0006\u0010L\u001a\u00020\nJ\u000e\u0010M\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u0018\u0010M\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\b\u0001\u0010N\u001a\u00020\u0004J\u000e\u0010M\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001cJ\u001a\u0010M\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010N\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u0002R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016\u00a8\u0006Q"}, d2={"Lando/toolkit/StatusBarUtils;", "", "()V", "STATUSBAR_TYPE_ANDROID6", "", "STATUSBAR_TYPE_DEFAULT", "STATUSBAR_TYPE_FLYME", "STATUSBAR_TYPE_MIUI", "STATUS_BAR_DEFAULT_HEIGHT_DP", "isMIUICustomStatusBarLightModeImpl", "", "()Z", "mStatusBarType", "getMStatusBarType$annotations", "sStatusBarHeight", "sTransparentValue", "Ljava/lang/Integer;", "sVirtualDensity", "", "getSVirtualDensity", "()F", "setSVirtualDensity", "(F)V", "sVirtualDensityDpi", "getSVirtualDensityDpi", "setSVirtualDensityDpi", "Android6SetStatusBarLightMode", "window", "Landroid/view/Window;", "light", "FlymeSetStatusBarLightMode", "MIUISetStatusBarLightMode", "calculateStatusColor", "color", "alpha", "cancelFullScreen", "", "activity", "Landroid/app/Activity;", "statusBarColor", "navigationBarColor", "fullScreen", "getStatusBarAPITransparentValue", "context", "Landroid/content/Context;", "(Landroid/content/Context;)Ljava/lang/Integer;", "getStatusbarHeight", "handleDisplayCutoutMode", "initStatusBarHeight", "isFullScreen", "realHandleDisplayCutoutMode", "decorView", "Landroid/view/View;", "retainSystemUiFlag", "out", "type", "setNavigationBarColor", "setStatusBarColor", "setStatusBarDarkMode", "setStatusBarDrawable", "drawable", "Landroid/graphics/drawable/Drawable;", "setStatusBarLightMode", "setStatusBarView", "setVirtualDensity", "density", "setVirtualDensityDpi", "densityDpi", "showDialogInFullScreen", "dialog", "Landroid/app/Dialog;", "showWindowInFullScreen", "onWindowShowListener", "Lando/toolkit/StatusBarUtils$OnWindowShowListener;", "supportTransclentStatusBar6", "supportTranslucent", "supportTransparentStatusBar", "translucent", "colorOn5x", "OnWindowShowListener", "StatusBarType", "ando_toolkit_release"})
public final class StatusBarUtils {
    @NotNull
    public static final StatusBarUtils INSTANCE = new StatusBarUtils();
    private static final int STATUSBAR_TYPE_DEFAULT = 0;
    private static final int STATUSBAR_TYPE_MIUI = 1;
    private static final int STATUSBAR_TYPE_FLYME = 2;
    private static final int STATUSBAR_TYPE_ANDROID6 = 3;
    private static final int STATUS_BAR_DEFAULT_HEIGHT_DP = 25;
    private static float sVirtualDensity = -1.0f;
    private static float sVirtualDensityDpi = -1.0f;
    private static int sStatusBarHeight = -1;
    private static int mStatusBarType;
    @Nullable
    private static Integer sTransparentValue;

    private StatusBarUtils() {
    }

    public final float getSVirtualDensity() {
        return sVirtualDensity;
    }

    public final void setSVirtualDensity(float f) {
        sVirtualDensity = f;
    }

    public final float getSVirtualDensityDpi() {
        return sVirtualDensityDpi;
    }

    public final void setSVirtualDensityDpi(float f) {
        sVirtualDensityDpi = f;
    }

    private static /* synthetic */ void getMStatusBarType$annotations() {
    }

    public final void translucent(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Window window = activity.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
        this.translucent(window);
    }

    public final void translucent(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        this.translucent(window, 0x40000000);
    }

    private final boolean supportTranslucent() {
        return !OSUtils.INSTANCE.isEssentialPhone() || Build.VERSION.SDK_INT >= 26;
    }

    public final void translucent(@NotNull Activity activity, @ColorInt int colorOn5x) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Window window = activity.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"window");
        this.translucent(window, colorOn5x);
    }

    @TargetApi(value=19)
    public final void translucent(@NotNull Window window, @ColorInt int colorOn5x) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        if (!this.supportTranslucent()) {
            return;
        }
        if (NotchUtils.INSTANCE.isNotchOfficialSupport()) {
            this.handleDisplayCutoutMode(window);
        }
        if (OSUtils.INSTANCE.isFlymeLowerThan(8) || OSUtils.INSTANCE.isMIUI() && Build.VERSION.SDK_INT < 23) {
            window.setFlags(0x4000000, 0x4000000);
            return;
        }
        int systemUiVisibility = window.getDecorView().getSystemUiVisibility();
        window.getDecorView().setSystemUiVisibility(systemUiVisibility |= 0x500);
        if (Build.VERSION.SDK_INT >= 23 && this.supportTransclentStatusBar6()) {
            window.clearFlags(0x4000000);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(0);
        } else {
            window.clearFlags(0x4000000);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(colorOn5x);
        }
    }

    public final int retainSystemUiFlag(@NotNull Window window, int out, int type) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        int realOut = out;
        int now = window.getDecorView().getSystemUiVisibility();
        if ((now & type) == type) {
            realOut |= type;
        }
        return realOut;
    }

    @TargetApi(value=28)
    private final void handleDisplayCutoutMode(Window window) {
        View view = window.getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"window.decorView");
        View decorView = view;
        if (ViewCompat.isAttachedToWindow((View)decorView)) {
            this.realHandleDisplayCutoutMode(window, decorView);
        } else {
            decorView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(window){
                final /* synthetic */ Window $window;
                {
                    this.$window = $window;
                }

                public void onViewAttachedToWindow(@NotNull View v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    StatusBarUtils.access$realHandleDisplayCutoutMode(StatusBarUtils.INSTANCE, this.$window, v);
                }

                public void onViewDetachedFromWindow(@NotNull View v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                }
            });
        }
    }

    @TargetApi(value=28)
    private final void realHandleDisplayCutoutMode(Window window, View decorView) {
        if (decorView.getRootWindowInsets() != null && decorView.getRootWindowInsets().getDisplayCutout() != null) {
            WindowManager.LayoutParams params = window.getAttributes();
            params.layoutInDisplayCutoutMode = 1;
            window.setAttributes(params);
        }
    }

    public final boolean setStatusBarLightMode(@Nullable Activity activity) {
        Window window;
        if (activity == null) {
            return false;
        }
        if (OSUtils.INSTANCE.isZTKC2016()) {
            return false;
        }
        if (mStatusBarType != 0) {
            return this.setStatusBarLightMode(activity, mStatusBarType);
        }
        if (this.isMIUICustomStatusBarLightModeImpl()) {
            window = activity.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
            if (this.MIUISetStatusBarLightMode(window, true)) {
                mStatusBarType = 1;
                return true;
            }
        }
        window = activity.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
        if (this.FlymeSetStatusBarLightMode(window, true)) {
            mStatusBarType = 2;
            return true;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            window = activity.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
            this.Android6SetStatusBarLightMode(window, true);
            mStatusBarType = 3;
            return true;
        }
        return false;
    }

    private final boolean setStatusBarLightMode(Activity activity, int type) {
        boolean bl;
        int n = type;
        switch (n) {
            case 1: {
                Window window = activity.getWindow();
                Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
                bl = this.MIUISetStatusBarLightMode(window, true);
                break;
            }
            case 2: {
                Window window = activity.getWindow();
                Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
                bl = this.FlymeSetStatusBarLightMode(window, true);
                break;
            }
            case 3: {
                Window window = activity.getWindow();
                Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
                bl = this.Android6SetStatusBarLightMode(window, true);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public final boolean setStatusBarDarkMode(@Nullable Activity activity) {
        boolean bl;
        if (activity == null) {
            return false;
        }
        if (mStatusBarType == 0) {
            return true;
        }
        int n = mStatusBarType;
        switch (n) {
            case 1: {
                Window window = activity.getWindow();
                Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
                bl = this.MIUISetStatusBarLightMode(window, false);
                break;
            }
            case 2: {
                Window window = activity.getWindow();
                Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
                bl = this.FlymeSetStatusBarLightMode(window, false);
                break;
            }
            case 3: {
                Window window = activity.getWindow();
                Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
                bl = this.Android6SetStatusBarLightMode(window, false);
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    @TargetApi(value=23)
    private final boolean Android6SetStatusBarLightMode(Window window, boolean light) {
        View view = window.getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"window.decorView");
        View decorView = view;
        int systemUi = decorView.getSystemUiVisibility();
        systemUi = light ? systemUi | 0x2000 : systemUi & 0xFFFFDFFF;
        decorView.setSystemUiVisibility(systemUi);
        if (OSUtils.INSTANCE.isMIUIV9()) {
            this.MIUISetStatusBarLightMode(window, light);
        }
        return true;
    }

    private final boolean MIUISetStatusBarLightMode(Window window, boolean light) {
        boolean result = false;
        Class<?> clazz = window.getClass();
        try {
            int darkModeFlag = 0;
            Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
            Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
            darkModeFlag = field.getInt(layoutParams);
            Object[] objectArray = new Class[]{Integer.TYPE, Integer.TYPE};
            Method extraFlagField = clazz.getMethod("setExtraFlags", (Class<?>[])objectArray);
            if (light) {
                objectArray = new Object[]{darkModeFlag, darkModeFlag};
                extraFlagField.invoke((Object)window, objectArray);
            } else {
                objectArray = new Object[]{0, darkModeFlag};
                extraFlagField.invoke((Object)window, objectArray);
            }
            result = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private final boolean isMIUICustomStatusBarLightModeImpl() {
        return OSUtils.INSTANCE.isMIUIV9() && Build.VERSION.SDK_INT < 23 ? true : OSUtils.INSTANCE.isMIUIV5() || OSUtils.INSTANCE.isMIUIV6() || OSUtils.INSTANCE.isMIUIV7() || OSUtils.INSTANCE.isMIUIV8();
    }

    private final boolean FlymeSetStatusBarLightMode(Window window, boolean light) {
        boolean result = false;
        this.Android6SetStatusBarLightMode(window, light);
        if (OSUtils.INSTANCE.isFlymeLowerThan(7)) {
            try {
                WindowManager.LayoutParams lp = window.getAttributes();
                Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
                Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
                darkFlag.setAccessible(true);
                meizuFlags.setAccessible(true);
                int bit = darkFlag.getInt(null);
                int value = meizuFlags.getInt(lp);
                value = light ? value | bit : value & ~bit;
                meizuFlags.setInt(lp, value);
                window.setAttributes(lp);
                result = true;
            }
            catch (Exception exception) {}
        } else if (OSUtils.INSTANCE.isFlyme()) {
            result = true;
        }
        return result;
    }

    public final boolean isFullScreen(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        boolean ret = false;
        try {
            WindowManager.LayoutParams attrs = activity.getWindow().getAttributes();
            ret = (attrs.flags & 0x400) != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Nullable
    public final Integer getStatusBarAPITransparentValue(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (sTransparentValue != null) {
            return sTransparentValue;
        }
        Object[] systemSharedLibraryNames = context.getPackageManager().getSystemSharedLibraryNames();
        String fieldName = null;
        if (systemSharedLibraryNames != null) {
            Iterator iterator = ArrayIteratorKt.iterator((Object[])systemSharedLibraryNames);
            while (iterator.hasNext()) {
                String lib = (String)iterator.next();
                if (Intrinsics.areEqual((Object)"touchwiz", (Object)lib)) {
                    fieldName = "SYSTEM_UI_FLAG_TRANSPARENT_BACKGROUND";
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)lib, (String)"lib");
                if (!StringsKt.startsWith$default((String)lib, (String)"com.sonyericsson.navigationbar", (boolean)false, (int)2, null)) continue;
                fieldName = "SYSTEM_UI_FLAG_TRANSPARENT";
            }
        }
        if (fieldName != null) {
            try {
                Field field = View.class.getField(fieldName);
                Class<?> type = field.getType();
                if (Intrinsics.areEqual(type, Integer.TYPE)) {
                    sTransparentValue = field.getInt(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sTransparentValue;
    }

    public final boolean supportTransclentStatusBar6() {
        return !OSUtils.INSTANCE.isZUKZ1() && !OSUtils.INSTANCE.isZTKC2016();
    }

    public final int getStatusbarHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (sStatusBarHeight == -1) {
            this.initStatusBarHeight(context);
        }
        return sStatusBarHeight;
    }

    @SuppressLint(value={"PrivateApi"})
    private final void initStatusBarHeight(Context context) {
        Class<?> clazz = null;
        Object obj = null;
        Field field = null;
        try {
            Class<?> clazz2 = Class.forName("com.android.internal.R$dimen");
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"forName(\"com.android.internal.R\\$dimen\")");
            clazz = clazz2;
            obj = clazz.newInstance();
            if (OSUtils.INSTANCE.isMeizu()) {
                try {
                    field = clazz.getField("status_bar_height_large");
                }
                catch (Throwable t2) {
                    t2.printStackTrace();
                }
            }
            if (field == null) {
                field = clazz.getField("status_bar_height");
            }
        }
        catch (Throwable t3) {
            t3.printStackTrace();
        }
        if (field != null && obj != null) {
            try {
                String string = field.get(obj).toString();
                boolean bl = false;
                int id2 = Integer.parseInt(string);
                sStatusBarHeight = context.getResources().getDimensionPixelSize(id2);
            }
            catch (Throwable t4) {
                t4.printStackTrace();
            }
        }
        if (sStatusBarHeight <= 0) {
            sStatusBarHeight = sVirtualDensity == -1.0f ? (int)((double)(context.getResources().getDisplayMetrics().density * (float)25) + 0.5) : (int)((float)25 * sVirtualDensity + 0.5f);
        }
    }

    public final void setVirtualDensity(float density) {
        sVirtualDensity = density;
    }

    public final void setVirtualDensityDpi(float densityDpi) {
        sVirtualDensityDpi = densityDpi;
    }

    public final void setStatusBarView(@NotNull Activity activity, @ColorRes int statusBarColor) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Build.VERSION.SDK_INT >= 21) {
            View view = activity.findViewById(0x1020002);
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.FrameLayout");
            }
            FrameLayout decorView = (FrameLayout)view;
            int count = decorView.getChildCount();
            if (count > 0) {
                int statusBarHeight = DeviceUtils.INSTANCE.getStatusBarHeight();
                View layout = decorView.getChildAt(0);
                ViewGroup.LayoutParams layoutParams = layout.getLayoutParams();
                if (layoutParams == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
                }
                FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams)layoutParams;
                layoutParams2.topMargin = statusBarHeight;
                View statusBarView = null;
                if (count > 1) {
                    View view2 = decorView.getChildAt(1);
                    if (view2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.view.View");
                    }
                    statusBarView = view2;
                } else {
                    statusBarView = new View((Context)activity);
                    LinearLayout.LayoutParams viewParams = new LinearLayout.LayoutParams(-1, statusBarHeight);
                    statusBarView.setLayoutParams((ViewGroup.LayoutParams)viewParams);
                    decorView.addView(statusBarView);
                }
                statusBarView.setBackgroundResource(statusBarColor);
            }
        }
    }

    public final void setStatusBarDrawable(@NotNull Activity activity, @Nullable Drawable drawable) {
        Field field;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                Class<?> decorViewClazz = Class.forName("com.android.internal.policy.DecorView");
                field = decorViewClazz.getDeclaredField("mSemiTransparentStatusBarColor");
                field.setAccessible(true);
                field.setInt(activity.getWindow().getDecorView(), 0);
            }
            catch (Exception decorViewClazz) {
                // empty catch block
            }
        }
        if (drawable == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            field = activity.findViewById(0x1020002);
            if (field == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.FrameLayout");
            }
            FrameLayout rootView = (FrameLayout)field;
            int count = rootView.getChildCount();
            if (count > 0) {
                View layout = rootView.getChildAt(0);
                int statusBarHeight = DeviceUtils.INSTANCE.getStatusBarHeight();
                ViewGroup.LayoutParams layoutParams = layout.getLayoutParams();
                if (layoutParams == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
                }
                FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams)layoutParams;
                layoutParams2.topMargin = statusBarHeight;
                ImageView statusBarView = null;
                if (count > 1) {
                    View view = rootView.getChildAt(1);
                    if (view == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.widget.ImageView");
                    }
                    statusBarView = (ImageView)view;
                } else {
                    statusBarView = new ImageView((Context)activity);
                    LinearLayout.LayoutParams viewParams = new LinearLayout.LayoutParams(-1, statusBarHeight);
                    statusBarView.setScaleType(ImageView.ScaleType.FIT_XY);
                    statusBarView.setLayoutParams((ViewGroup.LayoutParams)viewParams);
                    rootView.addView((View)statusBarView);
                }
                statusBarView.setImageDrawable(drawable);
            }
        }
    }

    public final boolean supportTransparentStatusBar() {
        return OSUtils.INSTANCE.isMIUI() || OSUtils.INSTANCE.isFlyme() || OSUtils.INSTANCE.isOppo() && Build.VERSION.SDK_INT >= 21 || Build.VERSION.SDK_INT >= 23;
    }

    public final void setStatusBarColor(@NotNull Window window, @ColorInt int color, int alpha) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        if (Build.VERSION.SDK_INT >= 21) {
            window.setStatusBarColor(this.calculateStatusColor(color, alpha));
        }
    }

    private final int calculateStatusColor(@ColorInt int color, int alpha) {
        if (alpha == 0) {
            return color;
        }
        float a = 1.0f - (float)alpha / 255.0f;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        red = (int)((double)((float)red * a) + 0.5);
        green = (int)((double)((float)green * a) + 0.5);
        blue = (int)((double)((float)blue * a) + 0.5);
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    public final void fullScreen(@Nullable Activity activity) {
        if (activity == null) {
            return;
        }
        Window window = activity.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
        this.fullScreen(window);
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    public final void fullScreen(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        int n = Build.VERSION.SDK_INT;
        boolean bl = 12 <= n ? n < 19 : false;
        if (bl) {
            window.getDecorView().setSystemUiVisibility(8);
        } else if (Build.VERSION.SDK_INT >= 19) {
            window.getDecorView().setSystemUiVisibility(4615);
        }
    }

    public final void cancelFullScreen(@NotNull Activity activity, @ColorInt int statusBarColor, @ColorInt int navigationBarColor) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Window window = activity.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
        this.cancelFullScreen(window, statusBarColor, navigationBarColor);
    }

    public final void cancelFullScreen(@NotNull Window window, @ColorInt int statusBarColor, @ColorInt int navigationBarColor) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        if (Build.VERSION.SDK_INT >= 21) {
            window.clearFlags(0xC000000);
            window.getDecorView().setSystemUiVisibility(0);
            window.addFlags(Integer.MIN_VALUE);
            if (statusBarColor != -1) {
                window.setStatusBarColor(statusBarColor);
            }
            if (navigationBarColor != -1) {
                window.setNavigationBarColor(navigationBarColor);
            }
        }
    }

    public final void cancelFullScreen(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Window window = activity.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
        this.cancelFullScreen(window);
    }

    public final void cancelFullScreen(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        this.cancelFullScreen(window, -1, -1);
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    public final void setNavigationBarColor(@NotNull Activity activity, int color) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Build.VERSION.SDK_INT > 21) {
            activity.getWindow().setNavigationBarColor(color);
        } else if (Build.VERSION.SDK_INT >= 19) {
            activity.getWindow().addFlags(0x8000000);
            ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
            View navigationBar = new View((Context)activity);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, DeviceUtils.INSTANCE.getNavBarHeight());
            params.gravity = 80;
            navigationBar.setLayoutParams((ViewGroup.LayoutParams)params);
            navigationBar.setBackgroundColor(color);
            decorView.addView(navigationBar);
        }
    }

    public final void showDialogInFullScreen(@NotNull Dialog dialog) {
        Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
        Window window = dialog.getWindow();
        if (window == null) {
            return;
        }
        Window window2 = window;
        this.showWindowInFullScreen(window2, new OnWindowShowListener(dialog){
            final /* synthetic */ Dialog $dialog;
            {
                this.$dialog = $dialog;
            }

            public void show(@NotNull Window window) {
                Intrinsics.checkNotNullParameter((Object)window, (String)"window");
                this.$dialog.show();
            }
        });
    }

    public final void showWindowInFullScreen(@NotNull Window window, @Nullable OnWindowShowListener onWindowShowListener) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        window.addFlags(8);
        OnWindowShowListener onWindowShowListener2 = onWindowShowListener;
        if (onWindowShowListener2 != null) {
            onWindowShowListener2.show(window);
        }
        this.fullScreen(window);
        window.clearFlags(8);
    }

    public static final /* synthetic */ void access$realHandleDisplayCutoutMode(StatusBarUtils $this, Window window, View decorView) {
        $this.realHandleDisplayCutoutMode(window, decorView);
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0083\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lando/toolkit/StatusBarUtils$StatusBarType;", "", "ando_toolkit_release"})
    private static @interface StatusBarType {
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lando/toolkit/StatusBarUtils$OnWindowShowListener;", "", "show", "", "window", "Landroid/view/Window;", "ando_toolkit_release"})
    public static interface OnWindowShowListener {
        public void show(@NotNull Window var1);
    }
}

