/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit;

import ando.toolkit.OSUtils;
import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.res.Resources;
import android.os.Binder;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001d\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0018H\u0002J\u0012\u0010'\u001a\u00020\u00162\b\u0010#\u001a\u0004\u0018\u00010$H\u0007J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u0004H\u0002J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u0004H\u0002J\u0006\u0010,\u001a\u00020\u0018J\u0006\u0010-\u001a\u00020\u001aJ\u0006\u0010.\u001a\u00020\u001aJ\"\u0010/\u001a\u0004\u0018\u00010\u00042\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0004H\u0002J\u000e\u00105\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$J\u0006\u00106\u001a\u00020\u001aJ\u0006\u00107\u001a\u00020\u001eJ\u0006\u00108\u001a\u00020\u001eJ\u000e\u00109\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$J\u0006\u0010:\u001a\u00020\u001eJ\u000e\u0010;\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020\u0018J\u001e\u0010;\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020\u00182\u0006\u0010=\u001a\u00020\u00182\u0006\u0010>\u001a\u00020\u0018J\u0006\u0010?\u001a\u00020\u001eJ\u0006\u0010@\u001a\u00020\u001eJ\u0006\u0010A\u001a\u00020\u001eJ\u0006\u0010B\u001a\u00020\u001eJ\u0006\u0010C\u001a\u00020\u001eJ\u0006\u0010D\u001a\u00020\u001eJ\u0006\u0010E\u001a\u00020\u001eJ\u0006\u0010F\u001a\u00020\u001eJ\u0006\u0010G\u001a\u00020\u001eJ\u001b\u0010H\u001a\u00020\u001e2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fH\u0002\u00a2\u0006\u0002\u0010JJ\u000e\u0010K\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$J\u0006\u0010L\u001a\u00020\u001eJ\u0006\u0010M\u001a\u00020\u001eJ\u0006\u0010N\u001a\u00020\u001eJ\u0006\u0010O\u001a\u00020\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lando/toolkit/OSUtils;", "", "()V", "BRAND", "", "CPU_FILE_PATH_0", "CPU_FILE_PATH_1", "CPU_FILE_PATH_2", "CPU_FILTER", "Ljava/io/FileFilter;", "ESSENTIAL", "FLYME", "KEY_FLYME_VERSION_NAME", "KEY_MIUI_VERSION_NAME", "MEIZUBOARD", "", "[Ljava/lang/String;", "POWER_PROFILE_CLASS", "TAG", "ZTEC2016", "ZUKZ1", "sBatteryCapacity", "", "sCpuCoreCount", "", "sExtraStorageSize", "", "sFlymeVersionName", "sInnerStorageSize", "sIsTabletChecked", "", "sIsTabletValue", "sMiuiVersionName", "sTotalMemory", "_isTablet", "context", "Landroid/content/Context;", "checkOp", "op", "getBatteryCapacity", "getCoresFromCPUFiles", "path", "getCoresFromFile", "file", "getCpuCoreCount", "getExtraStorageSize", "getInnerStorageSize", "getLowerCaseName", "p", "Ljava/util/Properties;", "get", "Ljava/lang/reflect/Method;", "key", "getTotalMemory", "getTotalStorageSize", "hasExtraStorage", "isEssentialPhone", "isFloatWindowOpAllowed", "isFlyme", "isFlymeLowerThan", "majorVersion", "minorVersion", "patchVersion", "isHuawei", "isMIUI", "isMIUIV5", "isMIUIV6", "isMIUIV7", "isMIUIV8", "isMIUIV9", "isMeizu", "isOppo", "isPhone", "boards", "([Ljava/lang/String;)Z", "isTablet", "isVivo", "isXiaomi", "isZTKC2016", "isZUKZ1", "ando_toolkit_release"})
public final class OSUtils {
    private static final String TAG = "QMUIDeviceHelper";
    private static final String KEY_MIUI_VERSION_NAME = "ro.miui.ui.version.name";
    private static final String KEY_FLYME_VERSION_NAME = "ro.build.display.id";
    private static final String FLYME = "flyme";
    private static final String ZTEC2016 = "zte c2016";
    private static final String ZUKZ1 = "zuk z1";
    private static final String ESSENTIAL = "essential";
    private static final String[] MEIZUBOARD;
    private static final String POWER_PROFILE_CLASS = "com.android.internal.os.PowerProfile";
    private static final String CPU_FILE_PATH_0 = "/sys/devices/system/cpu/";
    private static final String CPU_FILE_PATH_1 = "/sys/devices/system/cpu/possible";
    private static final String CPU_FILE_PATH_2 = "/sys/devices/system/cpu/present";
    private static final FileFilter CPU_FILTER;
    private static String sMiuiVersionName;
    private static String sFlymeVersionName;
    private static boolean sIsTabletChecked;
    private static boolean sIsTabletValue;
    private static final String BRAND;
    private static long sTotalMemory;
    private static long sInnerStorageSize;
    private static long sExtraStorageSize;
    private static double sBatteryCapacity;
    private static int sCpuCoreCount;
    @NotNull
    public static final OSUtils INSTANCE;

    private final boolean _isTablet(Context context) {
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        return (resources.getConfiguration().screenLayout & 0xF) >= 3;
    }

    public final boolean isTablet(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (sIsTabletChecked) {
            return sIsTabletValue;
        }
        sIsTabletValue = this._isTablet(context);
        sIsTabletChecked = true;
        return sIsTabletValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isFlyme() {
        CharSequence charSequence = sFlymeVersionName;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null) return false;
        if (StringsKt.isBlank((CharSequence)charSequence)) {
            return false;
        }
        boolean bl3 = false;
        if (bl3) return false;
        String string = sFlymeVersionName;
        if (string == null) return false;
        boolean bl4 = StringsKt.contains$default((CharSequence)string, (CharSequence)FLYME, (boolean)false, (int)2, null);
        if (!bl4) return false;
        return true;
    }

    public final boolean isMIUI() {
        CharSequence charSequence = sMiuiVersionName;
        boolean bl = false;
        boolean bl2 = false;
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
    }

    public final boolean isMIUIV5() {
        return Intrinsics.areEqual((Object)"v5", (Object)sMiuiVersionName);
    }

    public final boolean isMIUIV6() {
        return Intrinsics.areEqual((Object)"v6", (Object)sMiuiVersionName);
    }

    public final boolean isMIUIV7() {
        return Intrinsics.areEqual((Object)"v7", (Object)sMiuiVersionName);
    }

    public final boolean isMIUIV8() {
        return Intrinsics.areEqual((Object)"v8", (Object)sMiuiVersionName);
    }

    public final boolean isMIUIV9() {
        return Intrinsics.areEqual((Object)"v9", (Object)sMiuiVersionName);
    }

    public final boolean isFlymeLowerThan(int majorVersion) {
        return this.isFlymeLowerThan(majorVersion, 0, 0);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isFlymeLowerThan(int majorVersion, int minorVersion, int patchVersion) {
        boolean isLower = false;
        CharSequence charSequence = sFlymeVersionName;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            try {
                Pattern pattern = Pattern.compile("(\\d+\\.){2}\\d");
                Matcher matcher = pattern.matcher(sFlymeVersionName);
                Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"pattern.matcher(sFlymeVersionName)");
                Matcher matcher2 = matcher;
                if (matcher2.find()) {
                    String string = matcher2.group();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group()");
                    String versionString = string;
                    CharSequence charSequence2 = versionString;
                    boolean bl3 = false;
                    if (charSequence2.length() > 0) {
                        String[] version;
                        void $this$toTypedArray$iv;
                        Object object = versionString;
                        String string2 = "\\.";
                        int n = 0;
                        string2 = new Regex(string2);
                        n = 0;
                        boolean bl4 = false;
                        object = string2.split((CharSequence)object, n);
                        boolean $i$f$toTypedArray = false;
                        void thisCollection$iv = $this$toTypedArray$iv;
                        String[] stringArray = thisCollection$iv.toArray(new String[0]);
                        if (stringArray == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        object = version = stringArray;
                        boolean bl5 = false;
                        String[] stringArray2 = object;
                        bl4 = false;
                        if (!(stringArray2.length == 0)) {
                            object = version[0];
                            bl5 = false;
                            if (Integer.parseInt((String)object) < majorVersion) {
                                isLower = true;
                            }
                        }
                        if (version.length >= 2 && minorVersion > 0) {
                            object = version[1];
                            bl5 = false;
                            if (Integer.parseInt((String)object) < majorVersion) {
                                isLower = true;
                            }
                        }
                        if (version.length >= 3 && patchVersion > 0) {
                            object = version[2];
                            bl5 = false;
                            if (Integer.parseInt((String)object) < majorVersion) {
                                isLower = true;
                            }
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.isMeizu() && isLower;
    }

    public final boolean isMeizu() {
        return this.isPhone(MEIZUBOARD) || this.isFlyme();
    }

    public final boolean isXiaomi() {
        String string = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Build.MANUFACTURER");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
        Locale locale2 = locale;
        boolean bl = false;
        String string3 = string2;
        boolean bl2 = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
        return Intrinsics.areEqual((Object)string5, (Object)"xiaomi");
    }

    public final boolean isVivo() {
        return StringsKt.contains$default((CharSequence)BRAND, (CharSequence)"vivo", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)BRAND, (CharSequence)"bbk", (boolean)false, (int)2, null);
    }

    public final boolean isOppo() {
        return StringsKt.contains$default((CharSequence)BRAND, (CharSequence)"oppo", (boolean)false, (int)2, null);
    }

    public final boolean isHuawei() {
        return StringsKt.contains$default((CharSequence)BRAND, (CharSequence)"huawei", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)BRAND, (CharSequence)"honor", (boolean)false, (int)2, null);
    }

    public final boolean isEssentialPhone() {
        return StringsKt.contains$default((CharSequence)BRAND, (CharSequence)ESSENTIAL, (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isZUKZ1() {
        String board = Build.MODEL;
        if (board == null) return false;
        String string = board;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
        Locale locale2 = locale;
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)ZUKZ1, (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isZTKC2016() {
        String board = Build.MODEL;
        if (board == null) return false;
        String string = board;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
        Locale locale2 = locale;
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)ZTEC2016, (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final boolean isPhone(String[] boards) {
        String string = Build.BOARD;
        if (string == null) {
            return false;
        }
        String board = string;
        for (String board1 : boards) {
            if (!Intrinsics.areEqual((Object)board, (Object)board1)) continue;
            return true;
        }
        return false;
    }

    public final long getTotalMemory(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (sTotalMemory != -1L) {
            return sTotalMemory;
        }
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager activityManager = (ActivityManager)object;
        activityManager.getMemoryInfo(memoryInfo);
        sTotalMemory = memoryInfo.totalMem;
        return sTotalMemory;
    }

    public final long getInnerStorageSize() {
        if (sInnerStorageSize != -1L) {
            return sInnerStorageSize;
        }
        File file = Environment.getDataDirectory();
        if (file == null) {
            return 0L;
        }
        File dataDir = file;
        sInnerStorageSize = dataDir.getTotalSpace();
        return sInnerStorageSize;
    }

    public final boolean hasExtraStorage() {
        return Intrinsics.areEqual((Object)"mounted", (Object)Environment.getExternalStorageState());
    }

    public final long getExtraStorageSize() {
        File path;
        if (sExtraStorageSize != -1L) {
            return sExtraStorageSize;
        }
        if (!this.hasExtraStorage()) {
            return 0L;
        }
        File file = path = Environment.getExternalStorageDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"path");
        StatFs stat = new StatFs(file.getPath());
        long blockSize = stat.getBlockSizeLong();
        long availableBlocks = stat.getBlockCountLong();
        sExtraStorageSize = blockSize * availableBlocks;
        return sExtraStorageSize;
    }

    public final long getTotalStorageSize() {
        return this.getInnerStorageSize() + this.getExtraStorageSize();
    }

    public final int getCpuCoreCount() {
        if (sCpuCoreCount != -1) {
            return sCpuCoreCount;
        }
        int cores = 0;
        try {
            cores = this.getCoresFromFile(CPU_FILE_PATH_1);
            if (cores == 0) {
                cores = this.getCoresFromFile(CPU_FILE_PATH_2);
            }
            if (cores == 0) {
                cores = this.getCoresFromCPUFiles(CPU_FILE_PATH_0);
            }
        }
        catch (Exception e) {
            cores = 0;
        }
        if (cores == 0) {
            cores = 1;
        }
        sCpuCoreCount = cores;
        return cores;
    }

    private final int getCoresFromCPUFiles(String path) {
        File[] list = new File(path).listFiles(CPU_FILTER);
        return list != null ? list.length : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getCoresFromFile(String file) {
        int n;
        InputStream ins = null;
        try {
            int n2;
            Object object;
            String fileContents;
            block12: {
                block11: {
                    ins = new FileInputStream(file);
                    BufferedReader buf = new BufferedReader(new InputStreamReader(ins, StandardCharsets.UTF_8));
                    fileContents = buf.readLine();
                    buf.close();
                    if (fileContents == null) break block11;
                    CharSequence charSequence = fileContents;
                    object = new Regex("0-[\\d]+$");
                    n2 = 0;
                    if (object.matches(charSequence)) break block12;
                }
                int n3 = 0;
                ins.close();
                return n3;
            }
            object = fileContents;
            n2 = 2;
            boolean bl = false;
            String string = ((String)object).substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
            String num = string;
            object = num;
            n2 = 0;
            n = Integer.parseInt((String)object) + 1;
            ins.close();
        }
        catch (IOException e) {
            n = 0;
        }
        finally {
            InputStream inputStream = ins;
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return n;
    }

    public final boolean isFloatWindowOpAllowed(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.checkOp(context, 24);
    }

    @SuppressLint(value={"PrivateApi"})
    public final double getBatteryCapacity(@Nullable Context context) {
        double ret;
        double d;
        if (sBatteryCapacity != -1.0) {
            return sBatteryCapacity;
        }
        try {
            Class<?> cls = Class.forName(POWER_PROFILE_CLASS);
            Object instance = cls.getConstructor(Context.class).newInstance(context);
            Method method = cls.getMethod("getBatteryCapacity", new Class[0]);
            Object object = method.invoke(instance, new Object[0]);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
            }
            d = (Double)object;
        }
        catch (Exception ignore) {
            d = -1.0;
        }
        sBatteryCapacity = ret = d;
        return sBatteryCapacity;
    }

    private final boolean checkOp(Context context, int op) {
        Object object = context.getSystemService("appops");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.AppOpsManager");
        }
        AppOpsManager manager = (AppOpsManager)object;
        try {
            Method method = manager.getClass().getDeclaredMethod("checkOp", Integer.TYPE, Integer.TYPE, String.class);
            Object object2 = method.invoke((Object)manager, op, Binder.getCallingUid(), context.getPackageName());
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
            int property = (Integer)object2;
            return property == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private final String getLowerCaseName(Properties p, Method get, String key) {
        String name = p.getProperty(key);
        if (name == null) {
            try {
                Object object = get.invoke(null, key);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                name = (String)object;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (name != null) {
            String string = name;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
            Locale locale2 = locale;
            boolean bl = false;
            String string2 = string;
            boolean bl2 = false;
            String string3 = string2.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
            name = string3;
        }
        return name;
    }

    private OSUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static {
        OSUtils oSUtils;
        INSTANCE = oSUtils = new OSUtils();
        MEIZUBOARD = new String[]{"m9", "M9", "mx", "MX"};
        CPU_FILTER = CPU_FILTER.1.INSTANCE;
        String string = Build.BRAND;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Build.BRAND");
        String string2 = string;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ROOT");
        Locale locale2 = locale;
        boolean bl = false;
        String string3 = string2;
        boolean bl2 = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
        BRAND = string5;
        sTotalMemory = -1L;
        sInnerStorageSize = -1L;
        sExtraStorageSize = -1L;
        sBatteryCapacity = -1.0;
        sCpuCoreCount = -1;
        Properties properties = new Properties();
        if (Build.VERSION.SDK_INT < 26) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(new File(Environment.getRootDirectory(), "build.prop"));
                properties.load(fileInputStream);
            }
            catch (Exception exception) {
                FileInputStream fileInputStream2 = fileInputStream;
                if (fileInputStream2 != null) {
                    fileInputStream2.close();
                }
                catch (Throwable throwable) {
                    FileInputStream fileInputStream3 = fileInputStream;
                    if (fileInputStream3 != null) {
                        fileInputStream3.close();
                    }
                    throw throwable;
                }
            }
            fileInputStream.close();
        }
        Class<?> clzSystemProperties = null;
        try {
            Method getMethod;
            clzSystemProperties = Class.forName("android.os.SystemProperties");
            Method method = getMethod = clzSystemProperties.getDeclaredMethod("get", String.class);
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"getMethod");
            sMiuiVersionName = oSUtils.getLowerCaseName(properties, method, KEY_MIUI_VERSION_NAME);
            sFlymeVersionName = oSUtils.getLowerCaseName(properties, getMethod, KEY_FLYME_VERSION_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

