/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit;

import ando.toolkit.log.L;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.LightingColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.view.View;
import android.webkit.WebView;
import android.widget.ImageView;
import android.widget.ScrollView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.widget.NestedScrollView;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nJ0\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fJ\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00112\b\b\u0002\u0010\t\u001a\u00020\nJ*\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\fJ6\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\f2\b\b\u0001\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\f2\b\b\u0001\u0010\u001d\u001a\u00020\n2\b\b\u0001\u0010\u001e\u001a\u00020\nJ2\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010#\u001a\u00020\f2\b\b\u0001\u0010$\u001a\u00020\fJ*\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020\f2\b\b\u0001\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020+J\u0012\u0010,\u001a\u0004\u0018\u00010\u00062\b\u0010-\u001a\u0004\u0018\u00010.J\u001a\u0010/\u001a\u0004\u0018\u00010.2\u0006\u00100\u001a\u0002012\b\b\u0001\u00102\u001a\u00020\fJ\u001a\u00103\u001a\u0002042\b\u0010-\u001a\u0004\u0018\u00010.2\b\b\u0001\u00105\u001a\u00020\fJ\u001a\u00106\u001a\u0004\u0018\u00010\u00062\u0006\u00100\u001a\u0002012\b\b\u0001\u00102\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lando/toolkit/DrawableUtils;", "", "()V", "sCanvas", "Landroid/graphics/Canvas;", "createBitmapFromView", "Landroid/graphics/Bitmap;", "view", "Landroid/view/View;", "scale", "", "leftCrop", "", "topCrop", "rightCrop", "bottomCrop", "createBitmapFromWebView", "Landroid/webkit/WebView;", "createBitmapSafely", "width", "height", "config", "Landroid/graphics/Bitmap$Config;", "retryCount", "createCircleGradientDrawable", "Landroid/graphics/drawable/GradientDrawable;", "startColor", "endColor", "radius", "centerX", "centerY", "createDrawableWithSize", "Landroid/graphics/drawable/BitmapDrawable;", "resources", "Landroid/content/res/Resources;", "cornerRadius", "filledColor", "createItemSeparatorBg", "Landroid/graphics/drawable/LayerDrawable;", "separatorColor", "bgColor", "separatorHeight", "top", "", "drawableToBitmap", "drawable", "Landroid/graphics/drawable/Drawable;", "getVectorDrawable", "context", "Landroid/content/Context;", "resVector", "setDrawableTintColor", "Landroid/graphics/ColorFilter;", "tintColor", "vectorDrawableToBitmap", "ando_toolkit_release"})
public final class DrawableUtils {
    private final Canvas sCanvas = new Canvas();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Bitmap createBitmapFromView(@NotNull View view, float scale) {
        Bitmap bitmap;
        int i;
        int n;
        Drawable drawable;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (view instanceof ImageView && (drawable = ((ImageView)view).getDrawable()) instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        view.clearFocus();
        int viewHeight = 0;
        View view2 = view;
        if (view2 instanceof ScrollView) {
            int n2 = 0;
            n = ((ScrollView)view).getChildCount();
            while (n2 < n) {
                View view3 = ((ScrollView)view).getChildAt(i);
                Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"view.getChildAt(i)");
                viewHeight += view3.getHeight();
                ++i;
            }
        } else if (view2 instanceof NestedScrollView) {
            n = ((NestedScrollView)view).getChildCount();
            for (i = 0; i < n; ++i) {
                View view4 = ((NestedScrollView)view).getChildAt(i);
                Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"view.getChildAt(i)");
                viewHeight += view4.getHeight();
            }
        } else {
            viewHeight = view.getHeight();
        }
        if ((bitmap = this.createBitmapSafely((int)((float)view.getWidth() * scale), (int)((float)viewHeight * scale), Bitmap.Config.ARGB_8888, 1)) != null) {
            Canvas canvas = this.sCanvas;
            n = 0;
            boolean bl = false;
            synchronized (canvas) {
                boolean bl2 = false;
                Canvas canvas2 = this.sCanvas;
                canvas2.setBitmap(bitmap);
                canvas2.save();
                canvas2.drawColor(-1);
                canvas2.scale(scale, scale);
                view.draw(canvas2);
                canvas2.restore();
                canvas2.setBitmap(null);
                Unit unit = Unit.INSTANCE;
            }
        }
        return bitmap;
    }

    public static /* synthetic */ Bitmap createBitmapFromView$default(DrawableUtils drawableUtils, View view, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        return drawableUtils.createBitmapFromView(view, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Bitmap createBitmapFromWebView(@NotNull WebView view, float scale) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.clearFocus();
        int viewHeight = (int)((float)view.getContentHeight() * view.getScale());
        Bitmap bitmap = this.createBitmapSafely((int)((float)view.getWidth() * scale), (int)((float)viewHeight * scale), Bitmap.Config.ARGB_8888, 1);
        int unitHeight = view.getHeight();
        int bottom = viewHeight;
        if (bitmap != null) {
            Canvas canvas = this.sCanvas;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (canvas) {
                boolean bl3 = false;
                Canvas canvas2 = this.sCanvas;
                canvas2.setBitmap(bitmap);
                canvas2.drawColor(-1);
                canvas2.scale(scale, scale);
                while (bottom > 0) {
                    bottom = bottom < unitHeight ? 0 : (bottom -= unitHeight);
                    canvas2.save();
                    canvas2.clipRect(0, bottom, canvas2.getWidth(), bottom + unitHeight);
                    view.scrollTo(0, bottom);
                    view.draw(canvas2);
                    canvas2.restore();
                }
                canvas2.setBitmap(null);
                Unit unit = Unit.INSTANCE;
            }
        }
        return bitmap;
    }

    public static /* synthetic */ Bitmap createBitmapFromWebView$default(DrawableUtils drawableUtils, WebView webView, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        return drawableUtils.createBitmapFromWebView(webView, f);
    }

    @Nullable
    public final Bitmap createBitmapFromView(@NotNull View view, int leftCrop, int topCrop, int rightCrop, int bottomCrop) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Bitmap bitmap = DrawableUtils.createBitmapFromView$default(this, view, 0.0f, 2, null);
        if (bitmap == null) {
            return null;
        }
        Bitmap originBitmap = bitmap;
        Bitmap bitmap2 = this.createBitmapSafely(view.getWidth() - rightCrop - leftCrop, view.getHeight() - topCrop - bottomCrop, Bitmap.Config.ARGB_8888, 1);
        if (bitmap2 == null) {
            return null;
        }
        Bitmap cutBitmap = bitmap2;
        Canvas canvas = new Canvas(cutBitmap);
        Rect src = new Rect(leftCrop, topCrop, view.getWidth() - rightCrop, view.getHeight() - bottomCrop);
        Rect dest = new Rect(0, 0, view.getWidth() - rightCrop - leftCrop, view.getHeight() - topCrop - bottomCrop);
        canvas.drawColor(-1);
        canvas.drawBitmap(originBitmap, src, dest, null);
        originBitmap.recycle();
        return cutBitmap;
    }

    @Nullable
    public final Bitmap createBitmapSafely(int width, int height, @Nullable Bitmap.Config config, int retryCount) {
        Bitmap bitmap;
        if (width <= 0 || height <= 0) {
            bitmap = null;
        } else {
            Object var5_5;
            try {
                if (config != null) {
                    return Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
                }
                var5_5 = null;
            }
            catch (OutOfMemoryError e) {
                e.printStackTrace();
                if (retryCount > 0) {
                    System.gc();
                    return this.createBitmapSafely(width, height, config, retryCount - 1);
                }
                var5_5 = null;
            }
            bitmap = var5_5;
        }
        return bitmap;
    }

    @NotNull
    public final BitmapDrawable createDrawableWithSize(@Nullable Resources resources, int width, int height, int cornerRadius, @ColorInt int filledColor) {
        int color = filledColor;
        Bitmap output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        if (color == 0) {
            color = 0;
        }
        if (cornerRadius > 0) {
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            paint.setStyle(Paint.Style.FILL);
            paint.setColor(color);
            canvas.drawRoundRect(new RectF(0.0f, 0.0f, (float)width, (float)height), (float)cornerRadius, (float)cornerRadius, paint);
        } else {
            canvas.drawColor(color);
        }
        return new BitmapDrawable(resources, output);
    }

    @NotNull
    public final ColorFilter setDrawableTintColor(@Nullable Drawable drawable, @ColorInt int tintColor) {
        LightingColorFilter colorFilter = new LightingColorFilter(Color.argb((int)255, (int)0, (int)0, (int)0), tintColor);
        if (drawable != null) {
            drawable.setColorFilter((ColorFilter)colorFilter);
        }
        return (ColorFilter)colorFilter;
    }

    @Nullable
    public final Bitmap drawableToBitmap(@Nullable Drawable drawable) {
        Bitmap bitmap;
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        int intrinsicWidth = drawable.getIntrinsicWidth();
        int intrinsicHeight = drawable.getIntrinsicHeight();
        if (intrinsicWidth <= 0 || intrinsicHeight <= 0) {
            bitmap = null;
        } else {
            Bitmap bitmap2;
            try {
                Bitmap.Config config = drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
                Bitmap bitmap3 = Bitmap.createBitmap((int)intrinsicWidth, (int)intrinsicHeight, (Bitmap.Config)config);
                Canvas canvas = new Canvas(bitmap3);
                drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                drawable.draw(canvas);
                bitmap2 = bitmap3;
            }
            catch (OutOfMemoryError e) {
                e.printStackTrace();
                bitmap2 = null;
            }
            bitmap = bitmap2;
        }
        return bitmap;
    }

    @NotNull
    public final GradientDrawable createCircleGradientDrawable(@ColorInt int startColor, @ColorInt int endColor, int radius, @FloatRange(from=0.0, to=1.0) float centerX, @FloatRange(from=0.0, to=1.0) float centerY) {
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setColors(new int[]{startColor, endColor});
        gradientDrawable.setGradientType(1);
        gradientDrawable.setGradientRadius((float)radius);
        gradientDrawable.setGradientCenter(centerX, centerY);
        return gradientDrawable;
    }

    @NotNull
    public final LayerDrawable createItemSeparatorBg(@ColorInt int separatorColor, @ColorInt int bgColor, int separatorHeight, boolean top) {
        ShapeDrawable separator = new ShapeDrawable();
        Paint paint = separator.getPaint();
        Intrinsics.checkNotNullExpressionValue((Object)paint, (String)"separator.paint");
        paint.setStyle(Paint.Style.FILL);
        Paint paint2 = separator.getPaint();
        Intrinsics.checkNotNullExpressionValue((Object)paint2, (String)"separator.paint");
        paint2.setColor(separatorColor);
        ShapeDrawable bg = new ShapeDrawable();
        Paint paint3 = bg.getPaint();
        Intrinsics.checkNotNullExpressionValue((Object)paint3, (String)"bg.paint");
        paint3.setStyle(Paint.Style.FILL);
        Paint paint4 = bg.getPaint();
        Intrinsics.checkNotNullExpressionValue((Object)paint4, (String)"bg.paint");
        paint4.setColor(bgColor);
        Drawable[] layers = new Drawable[]{(Drawable)separator, (Drawable)bg};
        LayerDrawable layerDrawable = new LayerDrawable(layers);
        layerDrawable.setLayerInset(1, 0, top ? separatorHeight : 0, 0, top ? 0 : separatorHeight);
        return layerDrawable;
    }

    @Nullable
    public final Drawable getVectorDrawable(@NotNull Context context, @DrawableRes int resVector) {
        Drawable drawable;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            drawable = AppCompatResources.getDrawable((Context)context, (int)resVector);
        }
        catch (Exception e) {
            L.INSTANCE.d("123", "Error in getVectorDrawable. resVector=" + resVector + ", resName=" + context.getResources().getResourceName(resVector) + e.getMessage());
            drawable = null;
        }
        return drawable;
    }

    @Nullable
    public final Bitmap vectorDrawableToBitmap(@NotNull Context context, @DrawableRes int resVector) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Drawable drawable = this.getVectorDrawable(context, resVector);
        if (drawable != null) {
            Bitmap b = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(b);
            drawable.setBounds(0, 0, c.getWidth(), c.getHeight());
            drawable.draw(c);
            return b;
        }
        return null;
    }

    private DrawableUtils() {
    }
}

