/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit.ext;

import android.app.Activity;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.Build;
import android.view.Window;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005J\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005J\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\u0011"}, d2={"Lando/toolkit/ext/DeviceUtils;", "", "()V", "getCpuABIS", "", "", "()[Ljava/lang/String;", "getDeviceBrand", "getNavBarHeight", "", "getStatusBarHeight", "getStatusBarHeightDecor", "activity", "Landroid/app/Activity;", "getSystemDevice", "getSystemModel", "getSystemVersion", "ando_toolkit_release"})
public final class DeviceUtils {
    @NotNull
    public static final DeviceUtils INSTANCE;

    @Nullable
    public final String getSystemVersion() {
        return Build.VERSION.RELEASE;
    }

    @Nullable
    public final String getSystemModel() {
        return Build.MODEL;
    }

    @Nullable
    public final String getDeviceBrand() {
        return Build.BRAND;
    }

    @Nullable
    public final String getSystemDevice() {
        return Build.DEVICE;
    }

    @Nullable
    public final String[] getCpuABIS() {
        return Build.SUPPORTED_ABIS;
    }

    public final int getNavBarHeight() {
        Resources res = Resources.getSystem();
        int resourceId = res.getIdentifier("navigation_bar_height", "dimen", "android");
        return resourceId != 0 ? res.getDimensionPixelSize(resourceId) : 0;
    }

    public final int getStatusBarHeight() {
        Resources res = Resources.getSystem();
        int resourceId = res.getIdentifier("status_bar_height", "dimen", "android");
        return resourceId > 0 ? res.getDimensionPixelSize(resourceId) : 0;
    }

    public final int getStatusBarHeightDecor(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Rect localRect = new Rect();
        Window window = activity.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
        window.getDecorView().getWindowVisibleDisplayFrame(localRect);
        return localRect.top;
    }

    private DeviceUtils() {
    }

    static {
        DeviceUtils deviceUtils;
        INSTANCE = deviceUtils = new DeviceUtils();
    }
}

