/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.LightingColorFilter;
import android.graphics.Matrix;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0014\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\tJ\u0016\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000fJ\u001e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u000fJ\u001a\u0010\u001e\u001a\u00020\u001f2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0001\u0010 \u001a\u00020\u000fJ\u001e\u0010!\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u000f\u00a8\u0006$"}, d2={"Lando/toolkit/Utils;", "", "()V", "clearImageMemory", "", "imageView", "Landroid/widget/ImageView;", "clearImageView", "view", "Landroid/view/View;", "getBitmapFromDrawable", "Landroid/graphics/Bitmap;", "drawable", "Landroid/graphics/drawable/Drawable;", "color", "", "getNumberDigits", "number", "isLight", "", "isSupportColorAttrs", "recycleBackground", "v", "rotate", "bitmap", "angle", "setBackground", "context", "Landroid/content/Context;", "res", "setDrawableTintColor", "Landroid/graphics/ColorFilter;", "tintColor", "zoom", "w", "h", "ando_toolkit_release"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE;

    public final void setBackground(@NotNull Context context, @NotNull View v, int res) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Bitmap bm = BitmapFactory.decodeResource((Resources)context.getResources(), (int)res);
        BitmapDrawable bd = new BitmapDrawable(context.getResources(), bm);
        v.setBackground((Drawable)bd);
    }

    public final void recycleBackground(@NotNull View v) {
        Bitmap bmp;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Drawable d = v.getBackground();
        v.setBackgroundResource(0);
        if (d != null && d instanceof BitmapDrawable && (bmp = ((BitmapDrawable)d).getBitmap()) != null && !bmp.isRecycled()) {
            bmp.recycle();
        }
        if (d != null) {
            d.setCallback((Drawable.Callback)null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void clearImageView(@Nullable View view) {
        if (view instanceof ViewGroup) {
            int count = ((ViewGroup)view).getChildCount();
            int n = 0;
            int n2 = count;
            while (n < n2) {
                void i;
                this.clearImageView(((ViewGroup)view).getChildAt((int)i));
                ++i;
            }
        } else if (view instanceof ImageView) {
            this.clearImageMemory((ImageView)view);
        }
    }

    public final void clearImageMemory(@NotNull ImageView imageView) {
        Bitmap bmp;
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        Drawable d = imageView.getDrawable();
        if (d instanceof BitmapDrawable && (bmp = ((BitmapDrawable)d).getBitmap()) != null && !bmp.isRecycled()) {
            bmp.recycle();
        }
        imageView.setImageBitmap(null);
        if (d != null) {
            d.setCallback((Drawable.Callback)null);
        }
    }

    @NotNull
    public final Bitmap zoom(@NotNull Bitmap bitmap, int w, int h) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        Matrix matrix = new Matrix();
        float scaleWidth = (float)w / (float)width;
        float scaleHeight = (float)h / (float)height;
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"Bitmap.createBitmap(bitm\u2026th, height, matrix, true)");
        return bitmap2;
    }

    @NotNull
    public final Bitmap rotate(@NotNull Bitmap bitmap, int angle) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Matrix matrix = new Matrix();
        matrix.postRotate((float)angle);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"Bitmap.createBitmap(bitm\u2026map.height, matrix, true)");
        return bitmap2;
    }

    @NotNull
    public final Bitmap getBitmapFromDrawable(@NotNull Drawable drawable) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        int width = drawable.getIntrinsicWidth();
        int height = drawable.getIntrinsicHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)(drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, width, height);
        drawable.draw(canvas);
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"bitmap");
        return bitmap2;
    }

    @NotNull
    public final Bitmap getBitmapFromDrawable(@NotNull Drawable drawable, int color) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        int width = drawable.getIntrinsicWidth();
        int height = drawable.getIntrinsicHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)(drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        canvas.drawColor(color, PorterDuff.Mode.SRC_IN);
        drawable.setBounds(0, 0, width, height);
        drawable.draw(canvas);
        bitmap = bitmap.copy(Bitmap.Config.ARGB_8888, true);
        canvas = new Canvas(bitmap);
        canvas.drawColor(color, PorterDuff.Mode.SRC_IN);
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"bitmap");
        return bitmap2;
    }

    public final boolean isSupportColorAttrs() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public final boolean isLight(int color) {
        double d = (double)(Color.red((int)color) * Color.red((int)color)) * 0.241 + (double)(Color.green((int)color) * Color.green((int)color)) * 0.691 + (double)(Color.blue((int)color) * Color.blue((int)color)) * 0.068;
        boolean bl = false;
        return Math.sqrt(d) > (double)130;
    }

    public final int getNumberDigits(int number) {
        int n;
        if (number <= 0) {
            n = 0;
        } else {
            double d = number;
            boolean bl = false;
            n = (int)(Math.log10(d) + 1.0);
        }
        return n;
    }

    @NotNull
    public final ColorFilter setDrawableTintColor(@Nullable Drawable drawable, @ColorInt int tintColor) {
        LightingColorFilter colorFilter = new LightingColorFilter(Color.argb((int)255, (int)0, (int)0, (int)0), tintColor);
        if (drawable != null) {
            drawable.setColorFilter((ColorFilter)colorFilter);
        }
        return (ColorFilter)colorFilter;
    }

    private Utils() {
    }

    static {
        Utils utils;
        INSTANCE = utils = new Utils();
    }
}

