/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit;

import ando.toolkit.ScreenShotUtils;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.LruCache;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import androidx.core.widget.NestedScrollView;
import androidx.recyclerview.widget.RecyclerView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0006J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006J\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006J\u0016\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\u000eJ\u000e\u0010\"\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006#"}, d2={"Lando/toolkit/ScreenShotUtils;", "", "()V", "getNavigationBarHeight", "", "mActivity", "Landroid/app/Activity;", "getScreenH", "ctx", "Landroid/content/Context;", "getScreenW", "getStatusH", "getTitleH", "shotActivity", "Landroid/graphics/Bitmap;", "shotActivityWithoutStatusWithoutNavigationBar", "shotRecyclerView", "view", "Landroidx/recyclerview/widget/RecyclerView;", "shotScrollView", "scrollView", "Landroid/widget/ScrollView;", "shotView", "v", "Landroid/view/View;", "width", "height", "showActivityShotDialog", "", "activity", "showActivityWithoutStatusWithoutNavigationBarShotDialog", "showDialog", "context", "bitmap", "showRecyclerViewShotDialog", "ando_toolkit_release"})
public final class ScreenShotUtils {
    @NotNull
    public static final ScreenShotUtils INSTANCE;

    public final void showDialog(@NotNull Context context, @NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        NestedScrollView scrollView = new NestedScrollView(context);
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setOrientation(1);
        ImageView imageView = new ImageView(context);
        imageView.setScaleType(ImageView.ScaleType.FIT_XY);
        imageView.setImageBitmap(bitmap);
        linearLayout.addView((View)imageView);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        scrollView.addView((View)linearLayout);
        builder.setView((View)scrollView);
        builder.setCancelable(true);
        builder.setNegativeButton((CharSequence)"\u5173\u95ed", (DialogInterface.OnClickListener)showDialog.1.INSTANCE);
        builder.show();
    }

    public final void showActivityShotDialog(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.showDialog((Context)activity, this.shotActivity(activity));
    }

    public final void showActivityWithoutStatusWithoutNavigationBarShotDialog(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.showDialog((Context)activity, this.shotActivityWithoutStatusWithoutNavigationBar(activity));
    }

    public final void showRecyclerViewShotDialog(@NotNull RecyclerView view) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Bitmap bitmap = this.shotRecyclerView(view);
            if (bitmap == null) break block0;
            Bitmap bitmap2 = bitmap;
            boolean bl = false;
            boolean bl2 = false;
            Bitmap $this$apply = bitmap2;
            boolean bl3 = false;
            Context context = view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
            INSTANCE.showDialog(context, $this$apply);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Bitmap shotRecyclerView(@NotNull RecyclerView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        RecyclerView.Adapter adapter = view.getAdapter();
        Bitmap bigBitmap = null;
        if (adapter != null) {
            int size = adapter.getItemCount();
            int height = 0;
            Paint paint = new Paint();
            int iHeight = 0;
            int maxMemory = (int)(Runtime.getRuntime().maxMemory() / (long)1024);
            int cacheSize = maxMemory / 8;
            LruCache bitmapCache = new LruCache(cacheSize);
            RecyclerView.ViewHolder holder = null;
            int n = 0;
            int n2 = size;
            while (n < n2) {
                void i;
                holder = adapter.createViewHolder((ViewGroup)view, adapter.getItemViewType((int)i));
                adapter.onBindViewHolder(holder, (int)i);
                holder.itemView.measure(View.MeasureSpec.makeMeasureSpec((int)view.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                View view2 = holder.itemView;
                View view3 = holder.itemView;
                Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"holder.itemView");
                int n3 = view3.getMeasuredWidth();
                View view4 = holder.itemView;
                Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"holder.itemView");
                view2.layout(0, 0, n3, view4.getMeasuredHeight());
                View view5 = holder.itemView;
                Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"holder.itemView");
                view5.setDrawingCacheEnabled(true);
                holder.itemView.buildDrawingCache();
                View view6 = holder.itemView;
                Intrinsics.checkNotNullExpressionValue((Object)view6, (String)"holder.itemView");
                Bitmap drawingCache = view6.getDrawingCache();
                if (drawingCache != null) {
                    bitmapCache.put((Object)String.valueOf((int)i), (Object)drawingCache);
                }
                View view7 = holder.itemView;
                Intrinsics.checkNotNullExpressionValue((Object)view7, (String)"holder.itemView");
                height += view7.getMeasuredHeight();
                ++i;
            }
            bigBitmap = Bitmap.createBitmap((int)view.getMeasuredWidth(), (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas bigCanvas = new Canvas(bigBitmap);
            Drawable lBackground = view.getBackground();
            if (lBackground instanceof ColorDrawable) {
                int lColor = ((ColorDrawable)lBackground).getColor();
                bigCanvas.drawColor(lColor);
            }
            Bitmap bitmap = null;
            int n4 = 0;
            int n5 = size;
            while (n4 < n5) {
                void i;
                bitmap = (Bitmap)bitmapCache.get((Object)String.valueOf((int)i));
                bigCanvas.drawBitmap(bitmap, 0.0f, (float)iHeight, paint);
                Bitmap bitmap2 = bitmap;
                Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"bitmap");
                iHeight += bitmap2.getHeight();
                bitmap.recycle();
                ++i;
            }
        }
        return bigBitmap;
    }

    @NotNull
    public final Bitmap shotActivity(@NotNull Activity ctx) {
        View view;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Window window = ctx.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"ctx.window");
        View view2 = view = window.getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view");
        view2.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
        Bitmap bp = Bitmap.createBitmap((Bitmap)view.getDrawingCache(), (int)0, (int)0, (int)view.getMeasuredWidth(), (int)view.getMeasuredHeight());
        view.setDrawingCacheEnabled(false);
        view.destroyDrawingCache();
        Bitmap bitmap = bp;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bp");
        return bitmap;
    }

    @NotNull
    public final Bitmap shotActivityWithoutStatusWithoutNavigationBar(@NotNull Activity ctx) {
        View view;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        int statusH = this.getStatusH(ctx);
        int navigationBarH = this.getNavigationBarHeight(ctx);
        Window window = ctx.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"ctx.window");
        View view2 = view = window.getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view");
        view2.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
        Bitmap bp = Bitmap.createBitmap((Bitmap)view.getDrawingCache(), (int)0, (int)statusH, (int)view.getMeasuredWidth(), (int)(view.getMeasuredHeight() - statusH - navigationBarH));
        view.setDrawingCacheEnabled(false);
        view.destroyDrawingCache();
        Bitmap bitmap = bp;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bp");
        return bitmap;
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    public final int getScreenH(@NotNull Context ctx) {
        int n;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (Build.VERSION.SDK_INT > 13) {
            Point p = new Point();
            Object object = ctx.getSystemService("window");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
            }
            ((WindowManager)object).getDefaultDisplay().getSize(p);
            n = p.y;
        } else {
            Object object = ctx.getSystemService("window");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
            }
            Display display = ((WindowManager)object).getDefaultDisplay();
            Intrinsics.checkNotNullExpressionValue((Object)display, (String)"(ctx.getSystemService(Co\u2026owManager).defaultDisplay");
            n = display.getHeight();
        }
        return n;
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    public final int getScreenW(@NotNull Context ctx) {
        int n;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (Build.VERSION.SDK_INT > 13) {
            Point p = new Point();
            Object object = ctx.getSystemService("window");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
            }
            ((WindowManager)object).getDefaultDisplay().getSize(p);
            n = p.x;
        } else {
            Object object = ctx.getSystemService("window");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
            }
            Display display = ((WindowManager)object).getDefaultDisplay();
            Intrinsics.checkNotNullExpressionValue((Object)display, (String)"(ctx.getSystemService(Co\u2026owManager).defaultDisplay");
            n = display.getWidth();
        }
        return n;
    }

    public final int getStatusH(@NotNull Activity ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Rect s = new Rect();
        Window window = ctx.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"ctx.window");
        window.getDecorView().getWindowVisibleDisplayFrame(s);
        return s.top;
    }

    public final int getTitleH(@NotNull Activity ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        View view = ctx.getWindow().findViewById(0x1020002);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"ctx.window.findViewById<\u2026indow.ID_ANDROID_CONTENT)");
        int contentTop = view.getTop();
        return contentTop - this.getStatusH(ctx);
    }

    public final int getNavigationBarHeight(@NotNull Activity mActivity) {
        Intrinsics.checkNotNullParameter((Object)mActivity, (String)"mActivity");
        Resources resources = mActivity.getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        return resources.getDimensionPixelSize(resourceId);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Bitmap shotScrollView(@NotNull ScrollView scrollView) {
        Intrinsics.checkNotNullParameter((Object)scrollView, (String)"scrollView");
        int h = 0;
        Bitmap bitmap = null;
        int n = 0;
        int n2 = scrollView.getChildCount();
        while (n < n2) {
            void i;
            View view = scrollView.getChildAt((int)i);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"scrollView.getChildAt(i)");
            h += view.getHeight();
            scrollView.getChildAt((int)i).setBackgroundColor(Color.parseColor((String)"#ffffff"));
            ++i;
        }
        bitmap = Bitmap.createBitmap((int)scrollView.getWidth(), (int)h, (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas canvas = new Canvas(bitmap);
        scrollView.draw(canvas);
        return bitmap;
    }

    @NotNull
    public final Bitmap shotView(@NotNull View v, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Bitmap b = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(b);
        v.layout(0, 0, v.getLayoutParams().width, v.getLayoutParams().height);
        v.draw(c);
        Bitmap bitmap = b;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"b");
        return bitmap;
    }

    private ScreenShotUtils() {
    }

    static {
        ScreenShotUtils screenShotUtils;
        INSTANCE = screenShotUtils = new ScreenShotUtils();
    }
}

