/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;

public class NotificationUtils {
    private Context mContext;
    private Notification mNotification;
    private static final int NOTIFICATION_ID = 1;
    private static final String NOTIFICATION_CHANNEL_ID = String.format("app_channel_%s", "ando");
    private static final String NOTIFICATION_NAME = "\u540e\u53f0\u64ad\u653e\u8bfe\u7a0b";
    private NotificationManager mNotificationManager;

    public static boolean isNotificationEnabled(Context context) {
        boolean isOpened = false;
        try {
            NotificationManagerCompat manager = NotificationManagerCompat.from((Context)context);
            isOpened = manager.areNotificationsEnabled();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isOpened;
    }

    public static void gotoSet(Context context) {
        try {
            Intent intent = new Intent();
            if (Build.VERSION.SDK_INT >= 26) {
                intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
                intent.putExtra("android.provider.extra.APP_PACKAGE", context.getPackageName());
                intent.putExtra("android.provider.extra.CHANNEL_ID", context.getApplicationInfo().uid);
            }
            intent.putExtra("app_package", context.getPackageName());
            intent.putExtra("app_uid", context.getApplicationInfo().uid);
            intent.setFlags(0x10000000);
            if ("MI 6".equals(Build.MODEL)) {
                intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
                Uri uri = Uri.fromParts((String)"package", (String)context.getPackageName(), null);
                intent.setData(uri);
                intent.setAction("com.android.settings/.SubSettings");
            }
            context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            Intent intent = new Intent();
            intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            Uri uri = Uri.fromParts((String)"package", (String)context.getPackageName(), null);
            intent.setData(uri);
            intent.setFlags(0x10000000);
            context.startActivity(intent);
        }
    }

    public NotificationUtils(Context context) {
        this.mContext = context;
    }

    private NotificationManager getManager() {
        if (this.mNotificationManager == null) {
            this.mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        }
        return this.mNotificationManager;
    }

    private void initNotification() {
        this.initNotificationChannel();
        Intent intent = new Intent(this.mContext, this.mContext.getClass());
        PendingIntent contentIntent = PendingIntent.getActivity((Context)this.mContext, (int)1, (Intent)intent, (int)0x8000000);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.mContext, null).setContentTitle((CharSequence)"\u8bfe\u7a0b\u6b63\u5728\u540e\u53f0\u64ad\u653e").setContentText((CharSequence)"").setContentIntent(contentIntent).setWhen(System.currentTimeMillis()).setAutoCancel(true).setOngoing(false);
        if (Build.VERSION.SDK_INT >= 26) {
            builder.setChannelId(NOTIFICATION_CHANNEL_ID);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            builder.setVisibility(0);
        }
        this.mNotification = builder.build();
    }

    private void initNotificationChannel() {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(NOTIFICATION_CHANNEL_ID, (CharSequence)NOTIFICATION_NAME, 4);
            channel.setSound(null, null);
            channel.setLockscreenVisibility(0);
            this.getManager().createNotificationChannel(channel);
        }
    }
}

