/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit;

import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\t\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0016\u0010\t\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u001a\u0010\t\u001a\u0004\u0018\u00010\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\rJ\u001d\u0010\u0016\u001a\u00020\u00172\u0010\u0010\u0018\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\u001aJ%\u0010\u0016\u001a\u00020\u00172\u0010\u0010\u0018\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00192\u0006\u0010\u001b\u001a\u00020\r\u00a2\u0006\u0002\u0010\u001cJ\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dJ\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001b\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lando/toolkit/RandomUtils;", "", "()V", "CAPITAL_LETTERS", "", "LETTERS", "LOWER_CASE_LETTERS", "NUMBERS", "NUMBERS_AND_LETTERS", "getRandom", "sourceChar", "", "length", "", "max", "min", "source", "getRandomCapitalLetters", "getRandomLetters", "getRandomLowerCaseLetters", "getRandomNumbers", "getRandomNumbersAndLetters", "shuffle", "", "objArray", "", "([Ljava/lang/Object;)Z", "shuffleCount", "([Ljava/lang/Object;I)Z", "", "intArray", "ando_toolkit_release"})
public final class RandomUtils {
    @NotNull
    public static final RandomUtils INSTANCE = new RandomUtils();
    @NotNull
    public static final String NUMBERS_AND_LETTERS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    @NotNull
    public static final String NUMBERS = "0123456789";
    @NotNull
    public static final String LETTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    @NotNull
    public static final String CAPITAL_LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    @NotNull
    public static final String LOWER_CASE_LETTERS = "abcdefghijklmnopqrstuvwxyz";

    private RandomUtils() {
    }

    @Nullable
    public final String getRandomNumbersAndLetters(int length) {
        return this.getRandom(NUMBERS_AND_LETTERS, length);
    }

    @Nullable
    public final String getRandomNumbers(int length) {
        return this.getRandom(NUMBERS, length);
    }

    @Nullable
    public final String getRandomLetters(int length) {
        return this.getRandom(LETTERS, length);
    }

    @Nullable
    public final String getRandomCapitalLetters(int length) {
        return this.getRandom(CAPITAL_LETTERS, length);
    }

    @Nullable
    public final String getRandomLowerCaseLetters(int length) {
        return this.getRandom(LOWER_CASE_LETTERS, length);
    }

    @Nullable
    public final String getRandom(@Nullable String source, int length) {
        String string;
        if (source == null) {
            string = null;
        } else {
            String string2 = source;
            boolean bl = false;
            char[] cArray = string2.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            string = this.getRandom(cArray, length);
        }
        return string;
    }

    @Nullable
    public final String getRandom(@Nullable char[] sourceChar, int length) {
        if (sourceChar == null || sourceChar.length == 0 || length < 0) {
            return null;
        }
        StringBuilder str = new StringBuilder(length);
        Random random = new Random();
        int n = 0;
        if (n < length) {
            do {
                int i = n++;
                str.append(sourceChar[random.nextInt(sourceChar.length)]);
            } while (n < length);
        }
        return str.toString();
    }

    public final int getRandom(int max) {
        return this.getRandom(0, max);
    }

    public final int getRandom(int min, int max) {
        if (min > max) {
            return 0;
        }
        return min == max ? min : min + new Random().nextInt(max - min);
    }

    public final boolean shuffle(@Nullable Object[] objArray) {
        return objArray == null ? false : this.shuffle(objArray, this.getRandom(objArray.length));
    }

    public final boolean shuffle(@Nullable Object[] objArray, int shuffleCount) {
        int n;
        int length;
        block6: {
            block5: {
                length = 0;
                if (objArray == null || shuffleCount < 0) break block5;
                n = objArray.length;
                boolean bl = false;
                boolean bl2 = false;
                int it = n;
                boolean bl3 = false;
                length = it;
                if (n >= shuffleCount) break block6;
            }
            return false;
        }
        n = 1;
        if (n <= shuffleCount) {
            int i;
            do {
                i = n++;
                int random = this.getRandom(length - i);
                Object temp = objArray[length - i];
                objArray[length - i] = objArray[random];
                objArray[random] = temp;
            } while (i != shuffleCount);
        }
        return true;
    }

    @Nullable
    public final int[] shuffle(@Nullable int[] intArray) {
        return intArray == null ? (int[])null : this.shuffle(intArray, this.getRandom(intArray.length));
    }

    @Nullable
    public final int[] shuffle(@Nullable int[] intArray, int shuffleCount) {
        int n;
        int length;
        block6: {
            block5: {
                length = 0;
                if (intArray == null || shuffleCount < 0) break block5;
                int n2 = intArray.length;
                n = 0;
                boolean bl = false;
                int it = n2;
                boolean bl2 = false;
                length = it;
                if (n2 >= shuffleCount) break block6;
            }
            return null;
        }
        int[] out = new int[shuffleCount];
        n = 1;
        if (n <= shuffleCount) {
            int i;
            do {
                i = n++;
                int random = this.getRandom(length - i);
                out[i - 1] = intArray[random];
                int temp = intArray[length - i];
                intArray[length - i] = intArray[random];
                intArray[random] = temp;
            } while (i != shuffleCount);
        }
        return out;
    }
}

