/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0003J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tJ\b\u0010\u000b\u001a\u00020\u0004H\u0003J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\b\u0010\u000e\u001a\u00020\u0004H\u0003J\b\u0010\u000f\u001a\u00020\u0004H\u0007\u00a8\u0006\u0010"}, d2={"Lando/toolkit/DeviceIdUtils;", "", "()V", "bytesToHex", "", "data", "", "getAndroidId", "context", "Landroid/content/Context;", "getDeviceId", "getDeviceUUID", "getHashByString", "getIMEI", "getSERIAL", "getUUID", "ando_toolkit_release"})
public final class DeviceIdUtils {
    @NotNull
    public static final DeviceIdUtils INSTANCE = new DeviceIdUtils();

    private DeviceIdUtils() {
    }

    @SuppressLint(value={"MissingPermission", "HardwareIds"})
    @NotNull
    public final String getUUID() {
        String serial = null;
        String szDevIDShort = "35" + Build.BOARD.length() % 10 + Build.BRAND.length() % 10 + Build.CPU_ABI.length() % 10;
        int cfr_ignored_0 = Build.DEVICE.length() % 10 + Build.DISPLAY.length() % 10 + Build.HOST.length() % 10;
        int cfr_ignored_1 = Build.ID.length() % 10 + Build.MANUFACTURER.length() % 10 + Build.MODEL.length() % 10;
        int cfr_ignored_2 = Build.PRODUCT.length() % 10 + Build.TAGS.length() % 10 + Build.TYPE.length() % 10;
        int cfr_ignored_3 = Build.USER.length() % 10;
        try {
            serial = Build.VERSION.SDK_INT >= 26 ? Build.getSerial() : Build.SERIAL;
            String string = new UUID(szDevIDShort.hashCode(), serial.hashCode()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID(\n                szDevIDShort.hashCode().toLong(), serial.hashCode().toLong()\n            ).toString()");
            return string;
        }
        catch (Exception exception) {
            String string = serial = "serial";
            boolean bl = false;
            String string2 = new UUID(szDevIDShort.hashCode(), string.hashCode()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"UUID(szDevIDShort.hashCode().toLong(), serial.hashCode().toLong()).toString()");
            return string2;
        }
    }

    @Nullable
    public final String getDeviceId(@NotNull Context context) {
        CharSequence imei;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        StringBuilder sbDeviceId = new StringBuilder();
        String androidId = this.getAndroidId(context);
        String serial = this.getSERIAL();
        String uuid = StringsKt.replace$default((String)this.getDeviceUUID(), (String)"-", (String)"", (boolean)false, (int)4, null);
        if (Build.VERSION.SDK_INT < 23) {
            CharSequence charSequence = imei = this.getIMEI(context);
            boolean bl = false;
            if (charSequence.length() > 0) {
                sbDeviceId.append((String)imei);
                sbDeviceId.append("|");
            }
        }
        imei = androidId;
        boolean bl = false;
        if (imei.length() > 0) {
            sbDeviceId.append(androidId);
            sbDeviceId.append("|");
        }
        imei = serial;
        bl = false;
        if (imei.length() > 0) {
            sbDeviceId.append(serial);
            sbDeviceId.append("|");
        }
        imei = uuid;
        bl = false;
        if (imei.length() > 0) {
            sbDeviceId.append(uuid);
        }
        imei = sbDeviceId;
        bl = false;
        if (imei.length() > 0) {
            try {
                String string = sbDeviceId.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sbDeviceId.toString()");
                byte[] hash = this.getHashByString(string);
                String sha1 = this.bytesToHex(hash);
                CharSequence charSequence = sha1;
                boolean bl2 = false;
                if (charSequence.length() > 0) {
                    return sha1;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        return StringsKt.replace$default((String)string, (String)"-", (String)"", (boolean)false, (int)4, null);
    }

    @SuppressLint(value={"MissingPermission", "HardwareIds"})
    @NotNull
    public final String getIMEI(@NotNull Context context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            Object object = context.getSystemService("phone");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
            }
            TelephonyManager tm = (TelephonyManager)object;
            string = tm.getDeviceId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            val tm = context.getSystemService(Context.TELEPHONY_SERVICE) as TelephonyManager\n            @Suppress(\"DEPRECATION\")\n            tm.deviceId\n        }");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            string = "";
        }
        return string;
    }

    @SuppressLint(value={"HardwareIds"})
    private final String getAndroidId(Context context) {
        String string;
        try {
            string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            Settings.Secure.getString(context.contentResolver, Settings.Secure.ANDROID_ID)\n        }");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            string = "";
        }
        return string;
    }

    @SuppressLint(value={"HardwareIds"})
    private final String getSERIAL() {
        String string;
        try {
            string = Build.SERIAL;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            @Suppress(\"DEPRECATION\")\n            Build.SERIAL\n        }");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            string = "";
        }
        return string;
    }

    @SuppressLint(value={"HardwareIds"})
    private final String getDeviceUUID() {
        String string;
        try {
            String dev = "3883756" + Build.BOARD.length() % 10 + Build.BRAND.length() % 10 + Build.DEVICE.length() % 10;
            int cfr_ignored_0 = Build.HARDWARE.length() % 10 + Build.ID.length() % 10 + Build.MODEL.length() % 10;
            int cfr_ignored_1 = Build.PRODUCT.length() % 10 + Build.SERIAL.length() % 10;
            string = new UUID(dev.hashCode(), Build.SERIAL.hashCode()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n        val dev =\n            \"3883756\" + Build.BOARD.length % 10 + Build.BRAND.length % 10 + Build.DEVICE.length % 10\n        +Build.HARDWARE.length % 10 + Build.ID.length % 10 + Build.MODEL.length % 10\n        @Suppress(\"DEPRECATION\")\n        +Build.PRODUCT.length % 10 + Build.SERIAL.length % 10\n        @Suppress(\"DEPRECATION\")\n        UUID(dev.hashCode().toLong(), Build.SERIAL.hashCode().toLong()).toString()\n    }");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            string = "";
        }
        return string;
    }

    private final byte[] getHashByString(String data) {
        byte[] byArray;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.reset();
            String string = data;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray2 = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            messageDigest.update(byArray2);
            byArray = messageDigest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"{\n            val messageDigest = MessageDigest.getInstance(\"SHA1\")\n            messageDigest.reset()\n            messageDigest.update(data.toByteArray(StandardCharsets.UTF_8))\n            messageDigest.digest()\n        }");
        }
        catch (Exception e) {
            String string = "";
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray3 = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
            byArray = byArray3;
        }
        return byArray;
    }

    private final String bytesToHex(byte[] data) {
        String string;
        byte by;
        StringBuilder sb = new StringBuilder();
        String stmp = null;
        int n = 0;
        int n2 = data.length + -1;
        if (n <= n2) {
            do {
                int n3 = n++;
                by = data[n3];
                int n4 = -1;
                boolean bl = false;
                string = Integer.toHexString((byte)(by & n4));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString((data[n] and 0xFF.toByte()).toInt())");
                stmp = string;
                if (stmp.length() == 1) {
                    sb.append("0");
                }
                sb.append(stmp);
            } while (n <= n2);
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sb.toString()");
        Locale locale = Locale.CHINA;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"CHINA");
        boolean bl = false;
        string = string2;
        by = 0;
        String string3 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase(locale)");
        return string3;
    }
}

