/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.cfg;

import com.github.fge.Thawed;
import com.github.fge.jsonschema.SchemaVersion;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.core.exceptions.JsonReferenceException;
import com.github.fge.jsonschema.core.messages.JsonSchemaSyntaxMessageBundle;
import com.github.fge.jsonschema.core.ref.JsonRef;
import com.github.fge.jsonschema.library.DraftV3Library;
import com.github.fge.jsonschema.library.DraftV4Library;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.messages.JsonSchemaConfigurationBundle;
import com.github.fge.jsonschema.messages.JsonSchemaValidationBundle;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;

public final class ValidationConfigurationBuilder
implements Thawed<ValidationConfiguration> {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaConfigurationBundle.class);
    private static final Map<SchemaVersion, Library> DEFAULT_LIBRARIES = Maps.newEnumMap(SchemaVersion.class);
    final Map<JsonRef, Library> libraries;
    Library defaultLibrary = DEFAULT_LIBRARIES.get(SchemaVersion.DRAFTV4);
    boolean useFormat = true;
    MessageBundle syntaxMessages;
    MessageBundle validationMessages;

    ValidationConfigurationBuilder() {
        this.libraries = Maps.newHashMap();
        for (Map.Entry<SchemaVersion, Library> entry : DEFAULT_LIBRARIES.entrySet()) {
            JsonRef ref = JsonRef.fromURI((URI)entry.getKey().getLocation());
            Library library = entry.getValue();
            this.libraries.put(ref, library);
        }
        this.syntaxMessages = MessageBundles.getBundle(JsonSchemaSyntaxMessageBundle.class);
        this.validationMessages = MessageBundles.getBundle(JsonSchemaValidationBundle.class);
    }

    ValidationConfigurationBuilder(ValidationConfiguration cfg) {
        this.libraries = Maps.newHashMap(cfg.libraries);
        this.defaultLibrary = cfg.defaultLibrary;
        this.useFormat = cfg.useFormat;
        this.syntaxMessages = cfg.syntaxMessages;
        this.validationMessages = cfg.validationMessages;
    }

    public ValidationConfigurationBuilder addLibrary(String uri, Library library) {
        JsonRef ref;
        try {
            ref = JsonRef.fromString((String)uri);
        }
        catch (JsonReferenceException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        BUNDLE.checkArgumentPrintf(ref.isAbsolute(), "refProcessing.uriNotAbsolute", new Object[]{ref});
        BUNDLE.checkNotNull((Object)library, "nullLibrary");
        BUNDLE.checkArgumentPrintf(this.libraries.put(ref, library) == null, "dupLibrary", new Object[]{ref});
        return this;
    }

    public ValidationConfigurationBuilder setDefaultVersion(SchemaVersion version) {
        BUNDLE.checkNotNull((Object)version, "nullVersion");
        this.defaultLibrary = DEFAULT_LIBRARIES.get(version);
        return this;
    }

    public ValidationConfigurationBuilder setDefaultLibrary(String uri, Library library) {
        this.addLibrary(uri, library);
        this.defaultLibrary = library;
        return this;
    }

    public ValidationConfigurationBuilder setUseFormat(boolean useFormat) {
        this.useFormat = useFormat;
        return this;
    }

    public ValidationConfigurationBuilder setSyntaxMessages(MessageBundle syntaxMessages) {
        BUNDLE.checkNotNull((Object)syntaxMessages, "nullMessageBundle");
        this.syntaxMessages = syntaxMessages;
        return this;
    }

    public ValidationConfigurationBuilder setValidationMessages(MessageBundle validationMessages) {
        BUNDLE.checkNotNull((Object)validationMessages, "nullMessageBundle");
        this.validationMessages = validationMessages;
        return this;
    }

    public ValidationConfiguration freeze() {
        return new ValidationConfiguration(this);
    }

    static {
        DEFAULT_LIBRARIES.put(SchemaVersion.DRAFTV3, DraftV3Library.get());
        DEFAULT_LIBRARIES.put(SchemaVersion.DRAFTV4, DraftV4Library.get());
    }
}

