/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.exceptions.InvalidSchemaException;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.messages.SyntaxMessages;
import com.github.fge.jsonschema.processing.CachingProcessor;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.processors.data.SchemaContext;
import com.github.fge.jsonschema.processors.data.ValidatorList;
import com.github.fge.jsonschema.processors.validation.ArraySchemaDigester;
import com.github.fge.jsonschema.processors.validation.ArraySchemaSelector;
import com.github.fge.jsonschema.processors.validation.ObjectSchemaDigester;
import com.github.fge.jsonschema.processors.validation.ObjectSchemaSelector;
import com.github.fge.jsonschema.processors.validation.SchemaContextEquivalence;
import com.github.fge.jsonschema.report.MessageProvider;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.JsonTree;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public final class ValidationProcessor
implements Processor<FullData, FullData> {
    private final Processor<SchemaContext, ValidatorList> processor;
    private final LoadingCache<JsonNode, ArraySchemaSelector> arrayCache;
    private final LoadingCache<JsonNode, ObjectSchemaSelector> objectCache;

    public ValidationProcessor(Processor<SchemaContext, ValidatorList> processor) {
        this.processor = new CachingProcessor(processor, SchemaContextEquivalence.getInstance());
        this.arrayCache = CacheBuilder.newBuilder().build(ValidationProcessor.arrayLoader());
        this.objectCache = CacheBuilder.newBuilder().build(ValidationProcessor.objectLoader());
    }

    public FullData process(ProcessingReport report, FullData input) throws ProcessingException {
        SchemaContext context = new SchemaContext(input);
        ValidatorList fullContext = (ValidatorList)this.processor.process(report, (MessageProvider)context);
        if (fullContext == null) {
            throw new InvalidSchemaException(new ProcessingMessage().message((Object)SyntaxMessages.INVALID_SCHEMA));
        }
        SchemaContext newContext = fullContext.getContext();
        FullData data = new FullData(newContext.getSchema(), input.getInstance());
        for (KeywordValidator validator : fullContext) {
            validator.validate(this, report, data);
        }
        if (!report.isSuccess()) {
            return input;
        }
        JsonNode node = data.getInstance().getNode();
        if (node.size() == 0) {
            return input;
        }
        if (node.isArray()) {
            this.processArray(report, data);
        } else {
            this.processObject(report, data);
        }
        return input;
    }

    private void processArray(ProcessingReport report, FullData input) throws ProcessingException {
        SchemaTree tree = input.getSchema();
        JsonTree instance = input.getInstance();
        JsonNode schema = tree.getNode();
        JsonNode node = instance.getNode();
        JsonNode digest = ArraySchemaDigester.getInstance().digest(schema);
        ArraySchemaSelector selector = (ArraySchemaSelector)this.arrayCache.getUnchecked((Object)digest);
        int size = node.size();
        for (int index = 0; index < size; ++index) {
            JsonTree newInstance = instance.append(JsonPointer.of((Object)index, (Object[])new Object[0]));
            FullData data = input.withInstance(newInstance);
            for (JsonPointer ptr : selector.selectSchemas(index)) {
                data = data.withSchema(tree.append(ptr));
                this.process(report, data);
            }
        }
    }

    private void processObject(ProcessingReport report, FullData input) throws ProcessingException {
        SchemaTree tree = input.getSchema();
        JsonTree instance = input.getInstance();
        JsonNode schema = tree.getNode();
        JsonNode node = instance.getNode();
        JsonNode digest = ObjectSchemaDigester.getInstance().digest(schema);
        ObjectSchemaSelector selector = (ObjectSchemaSelector)this.objectCache.getUnchecked((Object)digest);
        ArrayList fields = Lists.newArrayList((Iterator)node.fieldNames());
        Collections.sort(fields);
        for (String field : fields) {
            JsonTree newInstance = instance.append(JsonPointer.of((Object)field, (Object[])new Object[0]));
            FullData data = input.withInstance(newInstance);
            for (JsonPointer ptr : selector.selectSchemas(field)) {
                data = data.withSchema(tree.append(ptr));
                this.process(report, data);
            }
        }
    }

    private static CacheLoader<JsonNode, ArraySchemaSelector> arrayLoader() {
        return new CacheLoader<JsonNode, ArraySchemaSelector>(){

            public ArraySchemaSelector load(JsonNode key) {
                return new ArraySchemaSelector(key);
            }
        };
    }

    private static CacheLoader<JsonNode, ObjectSchemaSelector> objectLoader() {
        return new CacheLoader<JsonNode, ObjectSchemaSelector>(){

            public ObjectSchemaSelector load(JsonNode key) {
                return new ObjectSchemaSelector(key);
            }
        };
    }

    public String toString() {
        return "validation processor";
    }
}

