/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.syntax.hyperschema.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.syntax.SyntaxChecker;
import com.github.fge.jsonschema.syntax.SyntaxValidator;
import com.github.fge.jsonschema.util.CharMatchers;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.net.MediaType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;

public final class LinksSyntaxChecker
extends AbstractSyntaxChecker {
    private static final Set<String> LDO_REQUIRED_MEMBERS = ImmutableSet.of((Object)"href", (Object)"rel");
    private static final Pattern HREF_TEMPLATE = Pattern.compile("\\{[^{}]*\\}");
    private static final SyntaxChecker INSTANCE = new LinksSyntaxChecker();

    private LinksSyntaxChecker() {
        super("links", NodeType.ARRAY, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    @Override
    public void checkValue(SyntaxValidator validator, List<Message> messages, JsonNode schema) {
        JsonNode value = schema.get(this.keyword);
        Message.Builder msg = this.newMsg();
        int size = value.size();
        for (int index = 0; index < size; ++index) {
            JsonNode ldo = value.get(index);
            NodeType type = NodeType.getNodeType(ldo);
            msg.addInfo("index", index);
            if (type != NodeType.OBJECT) {
                msg.addInfo("expected", NodeType.OBJECT).addInfo("found", type).setMessage("incorrect array element type");
                messages.add(msg.build());
                continue;
            }
            LinksSyntaxChecker.checkLDOSyntax(validator, msg, messages, ldo);
        }
    }

    private static void checkLDOSyntax(SyntaxValidator validator, Message.Builder msg, List<Message> messages, JsonNode ldo) {
        HashSet memberNames = Sets.newHashSet((Iterator)ldo.fieldNames());
        if (!memberNames.containsAll(LDO_REQUIRED_MEMBERS)) {
            TreeSet missing = Sets.newTreeSet(LDO_REQUIRED_MEMBERS);
            missing.removeAll(memberNames);
            msg.addInfo("required", LDO_REQUIRED_MEMBERS).addInfo("missing", missing).setMessage("missing required properties in link description object");
            messages.add(msg.build());
            return;
        }
        LinksSyntaxChecker.checkRelation(msg, messages, ldo);
        LinksSyntaxChecker.checkHref(msg, messages, ldo);
        if (ldo.has("targetSchema")) {
            JsonNode node = ldo.get("targetSchema");
            NodeType type = NodeType.getNodeType(node);
            if (type != NodeType.OBJECT) {
                msg.setMessage("incorrect type for targetSchema member").addInfo("expected", NodeType.OBJECT).addInfo("found", type);
                messages.add(msg.build());
            } else {
                validator.validate(messages, node);
            }
        }
        LinksSyntaxChecker.checkSubmissionLink(msg, messages, ldo);
    }

    private static void checkRelation(Message.Builder msg, List<Message> messages, JsonNode ldo) {
        JsonNode relNode = ldo.get("rel");
        NodeType type = NodeType.getNodeType(relNode);
        if (type != NodeType.STRING) {
            msg.setMessage("wrong node type for \"rel\" member").addInfo("expected", NodeType.STRING).addInfo("found", type);
            messages.add(msg.build());
            return;
        }
        String relation = relNode.textValue();
        if (relation.isEmpty()) {
            msg.setMessage("\"rel\" member value must not be empty");
            messages.add(msg.build());
            return;
        }
        if (!CharMatchers.LOALPHA.matches(relation.charAt(0))) {
            msg.setMessage("illegal \"rel\" member value: must start with a lowercase ASCII letter");
            messages.add(msg.build());
            return;
        }
        if (!CharMatchers.REL_TOKEN.matchesAllOf((CharSequence)relation.substring(1))) {
            msg.setMessage("illegal token in \"rel\" member value");
            messages.add(msg.build());
        }
    }

    private static void checkHref(Message.Builder msg, List<Message> messages, JsonNode ldo) {
        JsonNode hrefNode = ldo.get("href");
        NodeType type = NodeType.getNodeType(hrefNode);
        if (type != NodeType.STRING) {
            msg.setMessage("wrong node type for \"href\" member").addInfo("expected", NodeType.STRING).addInfo("found", type);
            messages.add(msg.build());
            return;
        }
        String template = hrefNode.textValue();
        String uri = HREF_TEMPLATE.matcher(template).replaceAll("foo");
        try {
            new URI(uri);
        }
        catch (URISyntaxException ignored) {
            msg.setMessage("expanded href value is not a URI").addInfo("template", template);
            messages.add(msg.build());
        }
    }

    private static void checkSubmissionLink(Message.Builder msg, List<Message> messages, JsonNode ldo) {
        NodeType type;
        if (ldo.has("schema") && (type = NodeType.getNodeType(ldo.get("schema"))) != NodeType.OBJECT) {
            msg.setMessage("incorrect type for schema member").addInfo("expected", NodeType.OBJECT).addInfo("found", type);
            messages.add(msg.build());
        }
        if (!ldo.has("enctype")) {
            return;
        }
        if (!ldo.has("method")) {
            msg.setMessage("enctype must be paired with method");
            messages.add(msg.build());
            return;
        }
        JsonNode node = ldo.get("enctype");
        type = NodeType.getNodeType(node);
        if (type != NodeType.STRING) {
            msg.setMessage("incorrect type for enctype").addInfo("found", type).addInfo("expected", NodeType.STRING);
            messages.add(msg.build());
        } else {
            try {
                MediaType.parse((String)node.textValue());
            }
            catch (IllegalArgumentException ignored) {
                msg.setMessage("enctype is not a valid media type").addInfo("value", node);
                messages.add(msg.build());
            }
        }
        node = ldo.get("method");
        type = NodeType.getNodeType(node);
        if (type != NodeType.STRING) {
            msg.setMessage("incorrect type for method").addInfo("found", type).addInfo("expected", NodeType.STRING);
            messages.add(msg.build());
        }
    }
}

