/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processing;

import com.github.fge.jsonschema.processing.LogThreshold;
import com.github.fge.jsonschema.processing.ProcessingContext;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.processing.ProcessingMessage;
import com.github.fge.jsonschema.processing.ProcessingReport;
import com.github.fge.jsonschema.tree.JsonSchemaTree;
import com.github.fge.jsonschema.tree.JsonTree;

public final class JsonSchemaContext
extends ProcessingContext<ProcessingReport> {
    private final ProcessingReport report = new ProcessingReport();
    private JsonSchemaTree schemaTree;
    private JsonTree tree;

    public JsonSchemaContext() {
        this(null, null);
    }

    public JsonSchemaContext(JsonSchemaTree schemaTree) {
        this(schemaTree, null);
    }

    public JsonSchemaContext(JsonSchemaTree schemaTree, JsonTree tree) {
        this.setLogThreshold(LogThreshold.INFO);
        this.schemaTree = schemaTree;
        this.tree = tree;
    }

    public JsonSchemaTree getSchemaTree() {
        return this.schemaTree;
    }

    public void setSchemaTree(JsonSchemaTree schemaTree) {
        this.schemaTree = schemaTree;
    }

    public JsonTree getTree() {
        return this.tree;
    }

    public void setTree(JsonTree tree) {
        this.tree = tree;
    }

    @Override
    public void log(ProcessingMessage msg) {
        this.report.addMessage(msg);
    }

    @Override
    public ProcessingException buildException(ProcessingMessage msg) {
        return new ProcessingException(msg);
    }

    @Override
    public ProcessingMessage newMessage() {
        ProcessingMessage ret = new ProcessingMessage();
        if (this.schemaTree != null) {
            ret.put("schema", this.schemaTree);
        }
        if (this.tree != null) {
            ret.put("instance", this.tree);
        }
        return ret;
    }

    @Override
    public ProcessingReport getOutput() {
        return this.report;
    }
}

