/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eel.kitchen.jsonschema.format.FormatAttribute;
import org.eel.kitchen.jsonschema.keyword.KeywordFactory;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.metaschema.KeywordRegistry;
import org.eel.kitchen.jsonschema.metaschema.MetaSchema;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.schema.SchemaNode;
import org.eel.kitchen.jsonschema.schema.SchemaRegistry;
import org.eel.kitchen.jsonschema.syntax.SyntaxValidator;
import org.eel.kitchen.jsonschema.util.jackson.JacksonUtils;
import org.eel.kitchen.jsonschema.validator.InstanceValidator;
import org.eel.kitchen.jsonschema.validator.JsonResolver;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class JsonValidatorCache {
    private static final JsonValidator ALWAYS_TRUE = new JsonValidator(){

        @Override
        public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        }
    };
    private final LoadingCache<SchemaNode, JsonValidator> cache;
    private final JsonResolver resolver;
    private final SyntaxValidator syntaxValidator;
    private final KeywordFactory keywordFactory;
    private final Map<String, FormatAttribute> formatAttributes;

    public JsonValidatorCache(MetaSchema metaSchema, SchemaRegistry schemaRegistry) {
        this.resolver = new JsonResolver(schemaRegistry);
        this.syntaxValidator = new SyntaxValidator(metaSchema);
        this.keywordFactory = new KeywordFactory(metaSchema);
        this.formatAttributes = metaSchema.getFormatAttributes();
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build(this.cacheLoader());
    }

    public JsonValidatorCache(KeywordRegistry keywordRegistry, SchemaRegistry schemaRegistry) {
        this.resolver = new JsonResolver(schemaRegistry);
        this.syntaxValidator = new SyntaxValidator(keywordRegistry);
        this.keywordFactory = new KeywordFactory(keywordRegistry);
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build(this.cacheLoader());
        this.formatAttributes = keywordRegistry.getFormatAttributes();
    }

    public Map<String, FormatAttribute> getFormatAttributes() {
        return this.formatAttributes;
    }

    public JsonValidator getValidator(SchemaNode schemaNode) {
        return (JsonValidator)this.cache.getUnchecked((Object)schemaNode);
    }

    private CacheLoader<SchemaNode, JsonValidator> cacheLoader() {
        return new CacheLoader<SchemaNode, JsonValidator>(){

            public JsonValidator load(SchemaNode key) {
                SchemaNode realNode;
                if (key.getNode().equals((Object)JacksonUtils.emptyObject())) {
                    return ALWAYS_TRUE;
                }
                try {
                    realNode = JsonValidatorCache.this.resolver.resolve(key);
                }
                catch (JsonSchemaException e) {
                    return new FailingValidator(e.getValidationMessage());
                }
                ArrayList messages = Lists.newArrayList();
                JsonValidatorCache.this.syntaxValidator.validate(messages, realNode.getNode());
                if (!messages.isEmpty()) {
                    return new FailingValidator(messages);
                }
                Set<KeywordValidator> validators = JsonValidatorCache.this.keywordFactory.getValidators(realNode.getNode());
                return new InstanceValidator(realNode, validators);
            }
        };
    }

    private static final class FailingValidator
    implements JsonValidator {
        private final List<Message> messages;

        private FailingValidator(Message message) {
            this.messages = ImmutableList.of((Object)message);
        }

        private FailingValidator(List<Message> messages) {
            this.messages = ImmutableList.copyOf(messages);
        }

        @Override
        public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
            report.addMessages(this.messages);
        }
    }
}

