/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eel.kitchen.jsonschema.metaschema.KeywordRegistry;
import org.eel.kitchen.jsonschema.metaschema.MetaSchema;
import org.eel.kitchen.jsonschema.report.Domain;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class SyntaxValidator {
    private final Map<String, SyntaxChecker> checkers;

    public SyntaxValidator(MetaSchema metaSchema) {
        this.checkers = metaSchema.getSyntaxCheckers();
    }

    public SyntaxValidator(KeywordRegistry registry) {
        this.checkers = registry.getSyntaxCheckers();
    }

    public void validate(List<Message> messages, JsonNode schema) {
        if (!schema.isObject()) {
            Message message = Domain.SYNTAX.newMessage().setKeyword("N/A").setMessage("illegal JSON Schema: not an object").addInfo("found", NodeType.getNodeType(schema)).build();
            messages.add(message);
            return;
        }
        HashSet keywords = Sets.newHashSet((Iterator)schema.fieldNames());
        keywords.retainAll(this.checkers.keySet());
        for (String keyword : keywords) {
            SyntaxChecker checker = this.checkers.get(keyword);
            checker.checkSyntax(this, messages, schema);
        }
    }
}

