/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import java.util.List;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.AbstractSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxValidator;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class DivisorSyntaxChecker
extends AbstractSyntaxChecker {
    public DivisorSyntaxChecker(String keyword) {
        super(keyword, NodeType.INTEGER, NodeType.NUMBER);
    }

    @Override
    public void checkValue(SyntaxValidator validator, List<Message> messages, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        if (node.decimalValue().compareTo(BigDecimal.ZERO) > 0) {
            return;
        }
        Message.Builder msg = this.newMsg().addInfo("value", node).setMessage(this.keyword + " is not strictly greater than 0");
        messages.add(msg.build());
    }
}

