/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.keyword.draftv4.SchemaArrayKeywordValidator;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class OneOfKeywordValidator
extends SchemaArrayKeywordValidator {
    public OneOfKeywordValidator(JsonNode schema) {
        super("oneOf", schema);
    }

    @Override
    protected void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        int matches = 0;
        for (JsonNode subSchema : this.subSchemas) {
            JsonValidator validator = context.newValidator(subSchema);
            ValidationReport subReport = new ValidationReport();
            validator.validate(context, subReport, instance);
            if (!subReport.isSuccess()) continue;
            ++matches;
        }
        if (matches == 1) {
            return;
        }
        Message.Builder msg = this.newMsg().addInfo("matches", matches).setMessage("instance does not match exactly one schema");
        report.addMessage(msg.build());
    }

    @Override
    public String toString() {
        return "one schema among " + this.subSchemas.size();
    }
}

