/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import org.eel.kitchen.jsonschema.ref.JsonRef;

public abstract class SchemaContainer {
    protected final JsonNode schema;
    protected final JsonRef locator;
    protected final int hashCode;

    protected SchemaContainer(URI uri, JsonNode node) {
        this.locator = JsonRef.fromURI(uri);
        this.schema = SchemaContainer.cleanup(node);
        this.hashCode = 31 * this.locator.hashCode() + this.schema.hashCode();
    }

    public abstract boolean contains(JsonRef var1);

    public abstract JsonNode resolve(JsonRef var1);

    public final JsonRef getLocator() {
        return this.locator;
    }

    public final JsonNode getSchema() {
        return this.schema;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SchemaContainer)) {
            return false;
        }
        SchemaContainer other = (SchemaContainer)obj;
        return this.locator.equals(other.locator) && this.schema.equals((Object)other.schema);
    }

    public final String toString() {
        return "locator: " + this.locator;
    }

    protected static JsonNode cleanup(JsonNode schema) {
        if (!schema.has("id")) {
            return schema;
        }
        ObjectNode ret = (ObjectNode)schema.deepCopy();
        ret.remove("id");
        return ret;
    }
}

