/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class NotKeywordValidator
extends KeywordValidator {
    private final JsonNode subSchema;

    public NotKeywordValidator(JsonNode schema) {
        super("not", NodeType.values());
        this.subSchema = schema.get(this.keyword);
    }

    @Override
    protected void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        ValidationReport subReport = new ValidationReport();
        JsonValidator validator = context.newValidator(this.subSchema);
        validator.validate(context, subReport, instance);
        if (subReport.isSuccess()) {
            report.addMessage(this.newMsg().setMessage("instance validates against a forbidden schema").build());
            return;
        }
        if (subReport.hasFatalError()) {
            report.mergeWith(subReport);
        }
    }

    @Override
    public String toString() {
        return "not: must not match enclosed schema";
    }
}

