/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.AbstractSyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class SchemaArraySyntaxChecker
extends AbstractSyntaxChecker {
    public SchemaArraySyntaxChecker(String keyword) {
        super(keyword, NodeType.ARRAY, new NodeType[0]);
    }

    @Override
    public void checkValue(Message.Builder msg, List<Message> messages, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        int size = node.size();
        if (size == 0) {
            msg.setMessage("array must have at least one element");
            messages.add(msg.build());
            return;
        }
        for (int index = 0; index < size; ++index) {
            NodeType type = NodeType.getNodeType(node.get(index));
            if (type == NodeType.OBJECT) continue;
            msg.setMessage("incorrect type for array element").addInfo("index", index).addInfo("found", type).addInfo("expected", NodeType.OBJECT);
            messages.add(msg.build());
        }
    }
}

