/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.metaschema;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eel.kitchen.jsonschema.syntax.DivisorSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.PositiveIntegerSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.TypeOnlySyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.common.EnumSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.common.ExclusiveMaximumSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.common.ExclusiveMinimumSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.common.PatternPropertiesSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.common.PatternSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.common.URISyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.draftv3.DraftV3DependenciesSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.draftv3.DraftV3ItemsSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.draftv3.DraftV3PropertiesSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.draftv3.DraftV3TypeKeywordSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.draftv3.ExtendsSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.draftv4.DraftV4DependenciesSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.draftv4.DraftV4ItemsSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.draftv4.DraftV4TypeSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.draftv4.RequiredSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.draftv4.SchemaArraySyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.hyperschema.draftv3.ContentEncodingSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.hyperschema.draftv3.FragmentResolutionSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.hyperschema.draftv3.LinksSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.hyperschema.draftv3.MediaTypeSyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class SyntaxCheckers {
    private static final Map<String, SyntaxChecker> DRAFTV3;
    private static final Map<String, SyntaxChecker> DRAFTV3_HYPERSCHEMA;
    private static final Map<String, SyntaxChecker> DRAFTV4;

    private SyntaxCheckers() {
    }

    public static Map<String, SyntaxChecker> draftV3() {
        return DRAFTV3;
    }

    public static Map<String, SyntaxChecker> draftV3HyperSchema() {
        return DRAFTV3_HYPERSCHEMA;
    }

    public static Map<String, SyntaxChecker> draftV4() {
        return DRAFTV4;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String keyword = "additionalItems";
        SyntaxChecker checker = new TypeOnlySyntaxChecker(keyword, NodeType.BOOLEAN, NodeType.OBJECT);
        builder.put((Object)keyword, (Object)checker);
        keyword = "minItems";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "maxItems";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "uniqueItems";
        checker = new TypeOnlySyntaxChecker(keyword, NodeType.BOOLEAN, new NodeType[0]);
        builder.put((Object)keyword, (Object)checker);
        keyword = "minimum";
        checker = new TypeOnlySyntaxChecker(keyword, NodeType.INTEGER, NodeType.NUMBER);
        builder.put((Object)keyword, (Object)checker);
        keyword = "exclusiveMinimum";
        checker = ExclusiveMinimumSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "maximum";
        checker = new TypeOnlySyntaxChecker(keyword, NodeType.INTEGER, NodeType.NUMBER);
        builder.put((Object)keyword, (Object)checker);
        keyword = "exclusiveMaximum";
        checker = ExclusiveMaximumSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "additionalProperties";
        checker = new TypeOnlySyntaxChecker(keyword, NodeType.BOOLEAN, NodeType.OBJECT);
        builder.put((Object)keyword, (Object)checker);
        keyword = "patternProperties";
        checker = PatternPropertiesSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "minLength";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "maxLength";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "pattern";
        checker = PatternSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "$schema";
        checker = new URISyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "$ref";
        checker = new URISyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "id";
        checker = new URISyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "description";
        checker = new TypeOnlySyntaxChecker(keyword, NodeType.STRING, new NodeType[0]);
        builder.put((Object)keyword, (Object)checker);
        keyword = "title";
        checker = new TypeOnlySyntaxChecker(keyword, NodeType.STRING, new NodeType[0]);
        builder.put((Object)keyword, (Object)checker);
        keyword = "enum";
        checker = EnumSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "format";
        checker = new TypeOnlySyntaxChecker(keyword, NodeType.STRING, new NodeType[0]);
        builder.put((Object)keyword, (Object)checker);
        ImmutableMap common = builder.build();
        builder = ImmutableMap.builder();
        builder.putAll((Map)common);
        keyword = "items";
        checker = DraftV3ItemsSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "divisibleBy";
        checker = new DivisorSyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "properties";
        checker = DraftV3PropertiesSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "dependencies";
        checker = DraftV3DependenciesSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "extends";
        checker = ExtendsSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "type";
        checker = new DraftV3TypeKeywordSyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "disallow";
        checker = new DraftV3TypeKeywordSyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        DRAFTV3 = builder.build();
        builder = ImmutableMap.builder();
        builder.putAll(DRAFTV3);
        keyword = "fragmentResolution";
        checker = FragmentResolutionSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "readonly";
        checker = new TypeOnlySyntaxChecker(keyword, NodeType.BOOLEAN, new NodeType[0]);
        builder.put((Object)keyword, (Object)checker);
        keyword = "contentEncoding";
        checker = ContentEncodingSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "pathStart";
        checker = new URISyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "mediaType";
        checker = MediaTypeSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "links";
        checker = LinksSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        DRAFTV3_HYPERSCHEMA = builder.build();
        builder = ImmutableMap.builder();
        builder.putAll((Map)common);
        keyword = "items";
        checker = DraftV4ItemsSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "multipleOf";
        checker = new DivisorSyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "minProperties";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "maxProperties";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "required";
        checker = RequiredSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "dependencies";
        checker = DraftV4DependenciesSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "anyOf";
        checker = new SchemaArraySyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "allOf";
        checker = new SchemaArraySyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "oneOf";
        checker = new SchemaArraySyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "not";
        checker = new TypeOnlySyntaxChecker(keyword, NodeType.OBJECT, new NodeType[0]);
        builder.put((Object)keyword, (Object)checker);
        keyword = "type";
        checker = DraftV4TypeSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        DRAFTV4 = builder.build();
    }
}

