/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format.common;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.net.URISyntaxException;
import org.eel.kitchen.jsonschema.format.FormatAttribute;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class URIFormatAttribute
extends FormatAttribute {
    private static final FormatAttribute instance = new URIFormatAttribute();

    private URIFormatAttribute() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatAttribute getInstance() {
        return instance;
    }

    @Override
    public void checkValue(String fmt, ValidationReport report, JsonNode value) {
        try {
            new URI(value.textValue());
        }
        catch (URISyntaxException ignored) {
            Message.Builder msg = URIFormatAttribute.newMsg(fmt).addInfo("value", value).setMessage("string is not a valid URI");
            report.addMessage(msg.build());
        }
    }
}

