/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class RequiredSyntaxChecker
extends SimpleSyntaxChecker {
    private static final SyntaxChecker instance = new RequiredSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return instance;
    }

    private RequiredSyntaxChecker() {
        super("required", NodeType.ARRAY, new NodeType[0]);
    }

    @Override
    public void checkValue(Message.Builder msg, List<Message> messages, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        int size = node.size();
        if (size == 0) {
            msg.setMessage("array must have at least one element");
            messages.add(msg.build());
            return;
        }
        HashSet set = Sets.newHashSet();
        for (int index = 0; index < size; ++index) {
            JsonNode element = node.get(index);
            NodeType type = NodeType.getNodeType(element);
            if (type != NodeType.STRING) {
                msg.clearInfo().setMessage("incorrect type for array element").addInfo("index", index).addInfo("found", type).addInfo("expected", NodeType.STRING);
                messages.add(msg.build());
                continue;
            }
            if (set.add(element.textValue())) continue;
            msg.setMessage("elements in the array must be unique");
            messages.add(msg.clearInfo().build());
            return;
        }
    }
}

