/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class DraftV4TypeSyntaxChecker
extends SimpleSyntaxChecker {
    private static final SyntaxChecker instance = new DraftV4TypeSyntaxChecker();
    private static final Set<String> VALID_TYPES;

    public static SyntaxChecker getInstance() {
        return instance;
    }

    private DraftV4TypeSyntaxChecker() {
        super("type", NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void checkValue(Message.Builder msg, List<Message> messages, JsonNode schema) {
        String value = schema.get(this.keyword).textValue();
        if (VALID_TYPES.contains(value)) {
            return;
        }
        msg.setMessage("unknown simple type").addInfo("value", value).addInfo("valid", VALID_TYPES);
        messages.add(msg.build());
    }

    static {
        TreeSet set = Sets.newTreeSet();
        for (NodeType type : NodeType.values()) {
            set.add(type.toString());
        }
        VALID_TYPES = ImmutableSet.copyOf((Collection)set);
    }
}

