/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class DraftV4ItemsSyntaxChecker
extends SimpleSyntaxChecker {
    private static final SyntaxChecker instance = new DraftV4ItemsSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return instance;
    }

    private DraftV4ItemsSyntaxChecker() {
        super("items", NodeType.ARRAY, NodeType.OBJECT);
    }

    @Override
    public void checkValue(Message.Builder msg, List<Message> messages, JsonNode schema) {
        JsonNode itemsNode = schema.get(this.keyword);
        if (!itemsNode.isArray()) {
            return;
        }
        if (itemsNode.size() < 1) {
            msg.setMessage("array must have at least one element");
            messages.add(msg.build());
            return;
        }
        int index = 0;
        for (JsonNode element : itemsNode) {
            NodeType elementType = NodeType.getNodeType(element);
            if (elementType != NodeType.OBJECT) {
                msg.setMessage("incorrect type for array element").addInfo("index", index).addInfo("found", elementType).addInfo("expected", NodeType.OBJECT);
                messages.add(msg.build());
            }
            ++index;
        }
    }
}

