/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.util.JacksonUtils;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class DraftV4DependenciesSyntaxChecker
extends SimpleSyntaxChecker {
    private static final SyntaxChecker instance = new DraftV4DependenciesSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return instance;
    }

    private DraftV4DependenciesSyntaxChecker() {
        super("dependencies", NodeType.OBJECT, new NodeType[0]);
    }

    @Override
    public void checkValue(Message.Builder msg, List<Message> messages, JsonNode schema) {
        Map<String, JsonNode> map = JacksonUtils.nodeToMap(schema.get(this.keyword));
        msg.setMessage("incorrect type for dependency value");
        for (Map.Entry<String, JsonNode> entry : map.entrySet()) {
            NodeType type = NodeType.getNodeType(entry.getValue());
            if (type == NodeType.OBJECT) continue;
            msg.addInfo("property", entry.getKey()).addInfo("found", type).addInfo("expected", NodeType.OBJECT);
            messages.add(msg.build());
        }
    }
}

