/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class ExtendsSyntaxChecker
extends SimpleSyntaxChecker {
    private static final SyntaxChecker instance = new ExtendsSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return instance;
    }

    private ExtendsSyntaxChecker() {
        super("extends", NodeType.ARRAY, NodeType.OBJECT);
    }

    @Override
    public void checkValue(Message.Builder msg, List<Message> messages, JsonNode schema) {
        JsonNode extendsNode = schema.get(this.keyword);
        if (!extendsNode.isArray()) {
            return;
        }
        int index = 0;
        for (JsonNode element : extendsNode) {
            NodeType elementType = NodeType.getNodeType(element);
            if (elementType != NodeType.OBJECT) {
                msg.setMessage("incorrect type for array element").addInfo("index", index).addInfo("found", elementType).addInfo("expected", NodeType.OBJECT);
                messages.add(msg.build());
            }
            ++index;
        }
    }
}

