/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.EnumSet;
import java.util.List;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;

public class SimpleSyntaxChecker
implements SyntaxChecker {
    protected final String keyword;
    private final EnumSet<NodeType> validTypes;

    public SimpleSyntaxChecker(String keyword, NodeType type, NodeType ... types) {
        this.keyword = keyword;
        this.validTypes = EnumSet.of(type, types);
    }

    @Override
    public final void checkSyntax(Message.Builder msg, List<Message> messages, JsonNode schema) {
        NodeType nodeType = NodeType.getNodeType(schema.get(this.keyword));
        if (!this.validTypes.contains((Object)nodeType)) {
            msg.addInfo("expected", this.validTypes).addInfo("found", nodeType).setKeyword(this.keyword).setMessage("incorrect type for value");
            messages.add(msg.build());
            return;
        }
        this.checkValue(msg, messages, schema);
    }

    public void checkValue(Message.Builder msg, List<Message> messages, JsonNode schema) {
    }
}

