/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import java.util.List;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;

public class ModZeroSyntaxChecker
extends SimpleSyntaxChecker {
    private static final BigDecimal ZERO = BigDecimal.ZERO;

    protected ModZeroSyntaxChecker(String keyword) {
        super(keyword, NodeType.INTEGER, NodeType.NUMBER);
    }

    @Override
    public final void checkValue(Message.Builder msg, List<Message> messages, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        if (node.decimalValue().compareTo(ZERO) > 0) {
            return;
        }
        msg.setMessage(this.keyword + " is not strictly greater than 0").addInfo("value", node);
        messages.add(msg.build());
    }
}

