/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.ref.JsonRef;

public final class SchemaBundle {
    private final JsonNode rootSchema;
    private final Map<URI, JsonNode> schemas = Maps.newHashMap();

    private SchemaBundle(URI uri, JsonNode schema) {
        this.rootSchema = schema;
        this.schemas.put(uri, schema);
    }

    public static SchemaBundle withRootSchema(URI uri, JsonNode schema) {
        JsonRef ref = JsonRef.fromURI(uri);
        if (!ref.isAbsolute()) {
            throw new IllegalArgumentException("Provided URI " + uri + " is not an absolute schema URI");
        }
        return new SchemaBundle(ref.getLocator(), schema);
    }

    public static SchemaBundle withRootSchema(String uriAsString, JsonNode schema) {
        return SchemaBundle.withRootSchema(URI.create(uriAsString), schema);
    }

    public static SchemaBundle withRootSchema(JsonNode schema) {
        JsonRef ref;
        if (!schema.has("id")) {
            throw new IllegalArgumentException("schema has no \"id\" member");
        }
        try {
            ref = JsonRef.fromNode(schema.get("id"));
            if (!ref.isAbsolute()) {
                throw new IllegalArgumentException("schema's id is not a valid schema locator");
            }
        }
        catch (JsonSchemaException ignored) {
            throw new IllegalArgumentException("schema's id is not a valid schema locator");
        }
        return new SchemaBundle(ref.getLocator(), schema);
    }

    public void addSchema(URI uri, JsonNode schema) {
        JsonRef ref = JsonRef.fromURI(uri);
        if (!ref.isAbsolute()) {
            throw new IllegalArgumentException("Provided URI " + uri + " is not an absolute schema URI");
        }
        this.schemas.put(ref.getLocator(), schema);
    }

    public void addSchema(String uriAsString, JsonNode schema) {
        this.addSchema(URI.create(uriAsString), schema);
    }

    public void addSchema(JsonNode schema) {
        JsonRef ref;
        if (!schema.has("id")) {
            throw new IllegalArgumentException("schema has no \"id\" member");
        }
        try {
            ref = JsonRef.fromNode(schema.get("id"));
            if (!ref.isAbsolute()) {
                throw new IllegalArgumentException("schema's id is not a valid schema locator");
            }
        }
        catch (JsonSchemaException ignored) {
            throw new IllegalArgumentException("schema's id is not a valid schema locator");
        }
        this.schemas.put(ref.getLocator(), schema);
    }

    public JsonNode getRootSchema() {
        return this.rootSchema;
    }

    public Map<URI, JsonNode> getSchemas() {
        return ImmutableMap.copyOf(this.schemas);
    }
}

