/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.report;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eel.kitchen.jsonschema.report.Domain;
import org.eel.kitchen.jsonschema.util.JacksonUtils;

public final class Message {
    private static final JsonNodeFactory factory = JsonNodeFactory.instance;
    private static final Joiner JOINER = Joiner.on((String)"; ");
    private final Domain domain;
    private final String keyword;
    private final String message;
    private final boolean fatal;
    private final Map<String, JsonNode> info;

    private Message(Builder builder) {
        this.domain = builder.domain;
        this.keyword = builder.keyword;
        this.message = builder.message;
        this.fatal = builder.fatal;
        this.info = ImmutableMap.copyOf(JacksonUtils.nodeToMap((JsonNode)builder.info));
    }

    public Domain getDomain() {
        return this.domain;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isFatal() {
        return this.fatal;
    }

    public JsonNode toJsonNode() {
        ObjectNode ret = factory.objectNode().put("domain", this.domain.toString()).put("keyword", this.keyword).put("message", this.message);
        if (this.fatal) {
            ret.put("fatal", true);
        }
        ret.putAll(this.info);
        return ret;
    }

    public int hashCode() {
        int ret = this.domain.hashCode();
        ret *= 31;
        ret += this.keyword.hashCode();
        ret *= 31;
        ret += this.message.hashCode();
        ret *= 31;
        ret += Boolean.valueOf(this.fatal).hashCode();
        ret *= 31;
        return ret += this.info.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Message other = (Message)obj;
        return this.domain == other.domain && this.keyword.equals(other.keyword) && this.message.equals(other.message) && this.fatal == other.fatal && this.info.equals(other.info);
    }

    public String toString() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("domain: " + this.domain.toString());
        list.add("keyword: " + this.keyword);
        list.add("message: " + this.message);
        for (String key : Ordering.natural().sortedCopy(this.info.keySet())) {
            list.add(key + ": " + this.info.get(key));
        }
        return (this.fatal ? "FATAL ERROR: " : "") + JOINER.join(list);
    }

    public static final class Builder {
        private static final Set<String> RESERVED = ImmutableSet.of((Object)"domain", (Object)"keyword", (Object)"message", (Object)"fatal");
        private final Domain domain;
        private String keyword;
        private String message;
        private final ObjectNode info = Message.access$400().objectNode();
        boolean fatal = false;

        Builder(Domain domain) {
            Preconditions.checkNotNull((Object)((Object)domain), (Object)"domain is null");
            this.domain = domain;
        }

        public Builder setKeyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setFatal(boolean fatal) {
            this.fatal = fatal;
            return this;
        }

        public Builder addInfo(String key, JsonNode value) {
            this.info.put(key, value);
            return this;
        }

        public <T> Builder addInfo(String key, T value) {
            this.info.put(key, value.toString());
            return this;
        }

        public <T> Builder addInfo(String key, Collection<T> values) {
            ArrayNode node = factory.arrayNode();
            for (T value : values) {
                node.add(value.toString());
            }
            this.info.put(key, (JsonNode)node);
            return this;
        }

        public Builder addInfo(String key, int value) {
            this.info.put(key, value);
            return this;
        }

        public Builder clearInfo() {
            this.info.removeAll();
            return this;
        }

        public Message build() {
            Preconditions.checkNotNull((Object)this.keyword, (Object)"keyword is null");
            Preconditions.checkNotNull((Object)this.message, (Object)"message is null");
            this.info.remove(RESERVED);
            return new Message(this);
        }
    }
}

