/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.metaschema;

import java.util.Map;
import org.eel.kitchen.jsonschema.metaschema.MapBuilder;
import org.eel.kitchen.jsonschema.syntax.PositiveIntegerSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.common.EnumSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.common.ExclusiveMaximumSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.common.ExclusiveMinimumSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.common.PatternPropertiesSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.common.PatternSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.common.URISyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.draftv3.DivisibleBySyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.draftv3.DraftV3DependenciesSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.draftv3.DraftV3ItemsSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.draftv3.DraftV3PropertiesSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.draftv3.DraftV3TypeKeywordSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.draftv3.ExtendsSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.draftv4.DraftV4DependenciesSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.draftv4.DraftV4ItemsSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.draftv4.DraftV4TypeSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.draftv4.MultipleOfSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.draftv4.RequiredSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.draftv4.SchemaArraySyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class SyntaxCheckers {
    private static final Map<String, SyntaxChecker> DRAFTV3;
    private static final Map<String, SyntaxChecker> DRAFTV4;

    private SyntaxCheckers() {
    }

    public static Map<String, SyntaxChecker> draftV3() {
        return DRAFTV3;
    }

    public static Map<String, SyntaxChecker> draftV4() {
        return DRAFTV4;
    }

    static {
        MapBuilder<SimpleSyntaxChecker> common = MapBuilder.create();
        String keyword = "additionalItems";
        SyntaxChecker checker = new SimpleSyntaxChecker(keyword, NodeType.BOOLEAN, NodeType.OBJECT);
        common.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "minItems";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        common.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "maxItems";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        common.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "uniqueItems";
        checker = new SimpleSyntaxChecker(keyword, NodeType.BOOLEAN, new NodeType[0]);
        common.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "minimum";
        checker = new SimpleSyntaxChecker(keyword, NodeType.INTEGER, NodeType.NUMBER);
        common.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "exclusiveMinimum";
        checker = ExclusiveMinimumSyntaxChecker.getInstance();
        common.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "maximum";
        checker = new SimpleSyntaxChecker(keyword, NodeType.INTEGER, NodeType.NUMBER);
        common.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "exclusiveMaximum";
        checker = ExclusiveMaximumSyntaxChecker.getInstance();
        common.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "additionalProperties";
        checker = new SimpleSyntaxChecker(keyword, NodeType.BOOLEAN, NodeType.OBJECT);
        common.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "patternProperties";
        checker = PatternPropertiesSyntaxChecker.getInstance();
        common.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "minLength";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        common.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "maxLength";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        common.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "pattern";
        checker = PatternSyntaxChecker.getInstance();
        common.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "$schema";
        checker = new URISyntaxChecker(keyword);
        common.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "$ref";
        checker = new URISyntaxChecker(keyword);
        common.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "id";
        checker = new URISyntaxChecker(keyword);
        common.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "description";
        checker = new SimpleSyntaxChecker(keyword, NodeType.STRING, new NodeType[0]);
        common.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "title";
        checker = new SimpleSyntaxChecker(keyword, NodeType.STRING, new NodeType[0]);
        common.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "enum";
        checker = EnumSyntaxChecker.getInstance();
        common.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "format";
        checker = new SimpleSyntaxChecker(keyword, NodeType.STRING, new NodeType[0]);
        common.put(keyword, (SimpleSyntaxChecker)checker);
        Map commonCheckers = common.build();
        MapBuilder<SimpleSyntaxChecker> draftv3 = MapBuilder.create();
        keyword = "items";
        checker = DraftV3ItemsSyntaxChecker.getInstance();
        draftv3.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "divisibleBy";
        checker = DivisibleBySyntaxChecker.getInstance();
        draftv3.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "properties";
        checker = DraftV3PropertiesSyntaxChecker.getInstance();
        draftv3.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "dependencies";
        checker = DraftV3DependenciesSyntaxChecker.getInstance();
        draftv3.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "extends";
        checker = ExtendsSyntaxChecker.getInstance();
        draftv3.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "type";
        checker = new DraftV3TypeKeywordSyntaxChecker(keyword);
        draftv3.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "disallow";
        checker = new DraftV3TypeKeywordSyntaxChecker(keyword);
        draftv3.put(keyword, (SimpleSyntaxChecker)checker);
        draftv3.putAll(commonCheckers);
        DRAFTV3 = draftv3.build();
        MapBuilder<SimpleSyntaxChecker> draftv4 = MapBuilder.create();
        keyword = "items";
        checker = DraftV4ItemsSyntaxChecker.getInstance();
        draftv4.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "multipleOf";
        checker = MultipleOfSyntaxChecker.getInstance();
        draftv4.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "minProperties";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        draftv4.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "maxProperties";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        draftv4.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "required";
        checker = RequiredSyntaxChecker.getInstance();
        draftv4.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "dependencies";
        checker = DraftV4DependenciesSyntaxChecker.getInstance();
        draftv4.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "anyOf";
        checker = new SchemaArraySyntaxChecker(keyword);
        draftv4.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "allOf";
        checker = new SchemaArraySyntaxChecker(keyword);
        draftv4.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "oneOf";
        checker = new SchemaArraySyntaxChecker(keyword);
        draftv4.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "not";
        checker = new SimpleSyntaxChecker(keyword, NodeType.OBJECT, new NodeType[0]);
        draftv4.put(keyword, (SimpleSyntaxChecker)checker);
        keyword = "type";
        checker = DraftV4TypeSyntaxChecker.getInstance();
        draftv4.put(keyword, (SimpleSyntaxChecker)checker);
        draftv4.putAll(commonCheckers);
        DRAFTV4 = draftv4.build();
    }
}

