/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.metaschema;

import java.util.Map;
import org.eel.kitchen.jsonschema.format.FormatAttribute;
import org.eel.kitchen.jsonschema.format.IPV4FormatAttribute;
import org.eel.kitchen.jsonschema.format.common.DateTimeFormatAttribute;
import org.eel.kitchen.jsonschema.format.common.EmailFormatAttribute;
import org.eel.kitchen.jsonschema.format.common.HostnameFormatAttribute;
import org.eel.kitchen.jsonschema.format.common.IPV6FormatAttribute;
import org.eel.kitchen.jsonschema.format.common.RegexFormatAttribute;
import org.eel.kitchen.jsonschema.format.common.URIFormatAttribute;
import org.eel.kitchen.jsonschema.format.draftv3.DateFormatAttribute;
import org.eel.kitchen.jsonschema.format.draftv3.PhoneNumberFormatAttribute;
import org.eel.kitchen.jsonschema.format.draftv3.TimeFormatAttribute;
import org.eel.kitchen.jsonschema.format.draftv3.UnixEpochFormatAttribute;
import org.eel.kitchen.jsonschema.metaschema.MapBuilder;

public final class FormatAttributes {
    private static final Map<String, FormatAttribute> DRAFTV3;
    private static final Map<String, FormatAttribute> DRAFTV4;

    private FormatAttributes() {
    }

    public static Map<String, FormatAttribute> draftV3() {
        return DRAFTV3;
    }

    public static Map<String, FormatAttribute> draftV4() {
        return DRAFTV4;
    }

    static {
        MapBuilder<FormatAttribute> common = MapBuilder.create();
        common.put("date-time", DateTimeFormatAttribute.getInstance());
        common.put("email", EmailFormatAttribute.getInstance());
        common.put("host-name", HostnameFormatAttribute.getInstance());
        common.put("ipv6", IPV6FormatAttribute.getInstance());
        common.put("regex", RegexFormatAttribute.getInstance());
        common.put("uri", URIFormatAttribute.getInstance());
        Map commonMap = common.build();
        MapBuilder<FormatAttribute> draftV3 = MapBuilder.create();
        draftV3.put("date", DateFormatAttribute.getInstance());
        draftV3.put("ip-address", IPV4FormatAttribute.getInstance());
        draftV3.put("phone", PhoneNumberFormatAttribute.getInstance());
        draftV3.put("time", TimeFormatAttribute.getInstance());
        draftV3.put("utc-millisec", UnixEpochFormatAttribute.getInstance());
        draftV3.putAll(commonMap);
        DRAFTV3 = draftV3.build();
        MapBuilder<FormatAttribute> draftV4 = MapBuilder.create();
        draftV4.put("ipv4", IPV4FormatAttribute.getInstance());
        draftV4.putAll(commonMap);
        DRAFTV4 = draftV4.build();
    }
}

