/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.main;

import com.google.common.base.Preconditions;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;

public final class Keyword {
    private final String name;
    private final SyntaxChecker syntaxChecker;
    private final Class<? extends KeywordValidator> validatorClass;

    private Keyword(Builder builder) {
        this.name = builder.keyword;
        this.syntaxChecker = builder.syntaxChecker;
        this.validatorClass = builder.validatorClass;
    }

    public static Builder withName(String name) {
        return new Builder(name);
    }

    public String getName() {
        return this.name;
    }

    public SyntaxChecker getSyntaxChecker() {
        return this.syntaxChecker;
    }

    public Class<? extends KeywordValidator> getValidatorClass() {
        return this.validatorClass;
    }

    public static final class Builder {
        private final String keyword;
        private SyntaxChecker syntaxChecker;
        private Class<? extends KeywordValidator> validatorClass;

        private Builder(String keyword) {
            Preconditions.checkNotNull((Object)keyword, (Object)"keyword name must not be null");
            this.keyword = keyword;
        }

        public Builder withSyntaxChecker(SyntaxChecker syntaxChecker) {
            this.syntaxChecker = syntaxChecker;
            return this;
        }

        public Builder withValidatorClass(Class<? extends KeywordValidator> validatorClass) {
            this.validatorClass = validatorClass;
            return this;
        }

        public Keyword build() {
            return new Keyword(this);
        }
    }
}

