/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.JacksonUtils;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class DraftV4DependenciesKeywordValidator
extends KeywordValidator {
    private final Map<String, JsonNode> dependencies;

    public DraftV4DependenciesKeywordValidator(JsonNode schema) {
        super("dependencies", NodeType.OBJECT);
        this.dependencies = ImmutableMap.copyOf(JacksonUtils.nodeToMap(schema.get(this.keyword)));
    }

    @Override
    protected void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        Set<String> fields = JacksonUtils.fieldNames(instance);
        TreeSet unsatisfied = Sets.newTreeSet();
        fields.retainAll(this.dependencies.keySet());
        for (String field : fields) {
            JsonNode subSchema = this.dependencies.get(field);
            JsonValidator validator = context.newValidator(subSchema);
            ValidationReport subReport = report.copy();
            validator.validate(context, subReport, instance);
            if (subReport.isSuccess()) continue;
            unsatisfied.add(field);
            report.mergeWith(subReport);
        }
        if (unsatisfied.isEmpty()) {
            return;
        }
        Message.Builder msg = this.newMsg().addInfo("unsatisfied", unsatisfied).setMessage("unsatisfied schema dependencies");
        report.addMessage(msg.build());
    }

    @Override
    public String toString() {
        return "schema dependencies on properties: " + this.dependencies.keySet();
    }
}

