/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.JacksonUtils;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class DraftV3PropertiesKeywordValidator
extends KeywordValidator {
    private final Set<String> required;

    public DraftV3PropertiesKeywordValidator(JsonNode schema) {
        super("properties", NodeType.OBJECT);
        Map<String, JsonNode> map = JacksonUtils.nodeToMap(schema.get(this.keyword));
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (Map.Entry<String, JsonNode> entry : map.entrySet()) {
            if (!entry.getValue().path("required").asBoolean(false)) continue;
            builder.add((Object)entry.getKey());
        }
        this.required = builder.build();
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        Set<String> fields = JacksonUtils.fieldNames(instance);
        if (fields.containsAll(this.required)) {
            return;
        }
        TreeSet requiredSorted = Sets.newTreeSet(this.required);
        TreeSet missing = Sets.newTreeSet(this.required);
        missing.removeAll(fields);
        Message.Builder msg = this.newMsg().addInfo("required", requiredSorted).addInfo("missing", missing).setMessage("required property(ies) not found");
        report.addMessage(msg.build());
    }

    @Override
    public boolean alwaysTrue() {
        return this.required.isEmpty();
    }

    @Override
    public String toString() {
        return this.keyword + ": " + (this.required.isEmpty() ? "none" : Integer.valueOf(this.required.size())) + " required";
    }
}

