/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigInteger;
import org.eel.kitchen.jsonschema.format.FormatAttribute;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class UnixEpochFormatAttribute
extends FormatAttribute {
    private static final FormatAttribute instance = new UnixEpochFormatAttribute();
    private static final int EPOCH_BITLENGTH = 31;
    private static final BigInteger ONE_THOUSAND = new BigInteger("1000");

    private UnixEpochFormatAttribute() {
        super(NodeType.INTEGER, NodeType.NUMBER);
    }

    public static FormatAttribute getInstance() {
        return instance;
    }

    @Override
    public void checkValue(String fmt, ValidationReport report, JsonNode value) {
        BigInteger epoch = value.bigIntegerValue();
        if (epoch.signum() == -1) {
            Message.Builder msg = UnixEpochFormatAttribute.newMsg(fmt).setMessage("epoch cannot be negative").addInfo("value", value);
            report.addMessage(msg.build());
            return;
        }
        if ((epoch = epoch.divide(ONE_THOUSAND)).bitLength() > 31) {
            Message.Builder msg = UnixEpochFormatAttribute.newMsg(fmt).setMessage("epoch time would overflow").addInfo("value", value);
            report.addMessage(msg.build());
        }
    }
}

